/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.services.ssm.model.ComplianceItemEntry;
import software.amazon.awssdk.services.ssm.model.ComplianceItemEntryListCopier;
import software.amazon.awssdk.services.ssm.model.ComplianceUploadType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutComplianceItemsRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, PutComplianceItemsRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::resourceId)).setter(PutComplianceItemsRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::resourceType)).setter(PutComplianceItemsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::complianceType)).setter(PutComplianceItemsRequest.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<ComplianceExecutionSummary> EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionSummary").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::executionSummary)).setter(PutComplianceItemsRequest.setter(Builder::executionSummary)).constructor(ComplianceExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()}).build();
    private static final SdkField<List<ComplianceItemEntry>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::items)).setter(PutComplianceItemsRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComplianceItemEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ITEM_CONTENT_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ItemContentHash").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::itemContentHash)).setter(PutComplianceItemsRequest.setter(Builder::itemContentHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemContentHash").build()}).build();
    private static final SdkField<String> UPLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UploadType").getter(PutComplianceItemsRequest.getter(PutComplianceItemsRequest::uploadTypeAsString)).setter(PutComplianceItemsRequest.setter(Builder::uploadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, COMPLIANCE_TYPE_FIELD, EXECUTION_SUMMARY_FIELD, ITEMS_FIELD, ITEM_CONTENT_HASH_FIELD, UPLOAD_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutComplianceItemsRequest.memberNameToFieldInitializer();
    private final String resourceId;
    private final String resourceType;
    private final String complianceType;
    private final ComplianceExecutionSummary executionSummary;
    private final List<ComplianceItemEntry> items;
    private final String itemContentHash;
    private final String uploadType;

    private PutComplianceItemsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.complianceType = builder.complianceType;
        this.executionSummary = builder.executionSummary;
        this.items = builder.items;
        this.itemContentHash = builder.itemContentHash;
        this.uploadType = builder.uploadType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final ComplianceExecutionSummary executionSummary() {
        return this.executionSummary;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ComplianceItemEntry> items() {
        return this.items;
    }

    public final String itemContentHash() {
        return this.itemContentHash;
    }

    public final ComplianceUploadType uploadType() {
        return ComplianceUploadType.fromValue(this.uploadType);
    }

    public final String uploadTypeAsString() {
        return this.uploadType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.itemContentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutComplianceItemsRequest)) {
            return false;
        }
        PutComplianceItemsRequest other = (PutComplianceItemsRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.executionSummary(), other.executionSummary()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.itemContentHash(), other.itemContentHash()) && Objects.equals(this.uploadTypeAsString(), other.uploadTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutComplianceItemsRequest").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceType()).add("ComplianceType", (Object)this.complianceType()).add("ExecutionSummary", (Object)this.executionSummary()).add("Items", this.hasItems() ? this.items() : null).add("ItemContentHash", (Object)this.itemContentHash()).add("UploadType", (Object)this.uploadTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "ExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.executionSummary()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "ItemContentHash": {
                return Optional.ofNullable(clazz.cast(this.itemContentHash()));
            }
            case "UploadType": {
                return Optional.ofNullable(clazz.cast(this.uploadTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
        map.put("ExecutionSummary", EXECUTION_SUMMARY_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("ItemContentHash", ITEM_CONTENT_HASH_FIELD);
        map.put("UploadType", UPLOAD_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutComplianceItemsRequest, T> g) {
        return obj -> g.apply((PutComplianceItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String complianceType;
        private ComplianceExecutionSummary executionSummary;
        private List<ComplianceItemEntry> items = DefaultSdkAutoConstructList.getInstance();
        private String itemContentHash;
        private String uploadType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutComplianceItemsRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.complianceType(model.complianceType);
            this.executionSummary(model.executionSummary);
            this.items(model.items);
            this.itemContentHash(model.itemContentHash);
            this.uploadType(model.uploadType);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return this.executionSummary != null ? this.executionSummary.toBuilder() : null;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final List<ComplianceItemEntry.Builder> getItems() {
            List<ComplianceItemEntry.Builder> result = ComplianceItemEntryListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ComplianceItemEntry.BuilderImpl> items) {
            this.items = ComplianceItemEntryListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ComplianceItemEntry> items) {
            this.items = ComplianceItemEntryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ComplianceItemEntry ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ComplianceItemEntry.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ComplianceItemEntry)((ComplianceItemEntry.Builder)ComplianceItemEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getItemContentHash() {
            return this.itemContentHash;
        }

        public final void setItemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
        }

        @Override
        public final Builder itemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
            return this;
        }

        public final String getUploadType() {
            return this.uploadType;
        }

        public final void setUploadType(String uploadType) {
            this.uploadType = uploadType;
        }

        @Override
        public final Builder uploadType(String uploadType) {
            this.uploadType = uploadType;
            return this;
        }

        @Override
        public final Builder uploadType(ComplianceUploadType uploadType) {
            this.uploadType(uploadType == null ? null : uploadType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutComplianceItemsRequest build() {
            return new PutComplianceItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutComplianceItemsRequest> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder complianceType(String var1);

        public Builder executionSummary(ComplianceExecutionSummary var1);

        default public Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return this.executionSummary((ComplianceExecutionSummary)((ComplianceExecutionSummary.Builder)ComplianceExecutionSummary.builder().applyMutation(executionSummary)).build());
        }

        public Builder items(Collection<ComplianceItemEntry> var1);

        public Builder items(ComplianceItemEntry ... var1);

        public Builder items(Consumer<ComplianceItemEntry.Builder> ... var1);

        public Builder itemContentHash(String var1);

        public Builder uploadType(String var1);

        public Builder uploadType(ComplianceUploadType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

