/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.MetadataKeysToDeleteListCopier;
import software.amazon.awssdk.services.ssm.model.MetadataMapCopier;
import software.amazon.awssdk.services.ssm.model.MetadataValue;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOpsMetadataRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateOpsMetadataRequest> {
    private static final SdkField<String> OPS_METADATA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsMetadataArn").getter(UpdateOpsMetadataRequest.getter(UpdateOpsMetadataRequest::opsMetadataArn)).setter(UpdateOpsMetadataRequest.setter(Builder::opsMetadataArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsMetadataArn").build()}).build();
    private static final SdkField<Map<String, MetadataValue>> METADATA_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetadataToUpdate").getter(UpdateOpsMetadataRequest.getter(UpdateOpsMetadataRequest::metadataToUpdate)).setter(UpdateOpsMetadataRequest.setter(Builder::metadataToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataToUpdate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeysToDelete").getter(UpdateOpsMetadataRequest.getter(UpdateOpsMetadataRequest::keysToDelete)).setter(UpdateOpsMetadataRequest.setter(Builder::keysToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeysToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_METADATA_ARN_FIELD, METADATA_TO_UPDATE_FIELD, KEYS_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOpsMetadataRequest.memberNameToFieldInitializer();
    private final String opsMetadataArn;
    private final Map<String, MetadataValue> metadataToUpdate;
    private final List<String> keysToDelete;

    private UpdateOpsMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.opsMetadataArn = builder.opsMetadataArn;
        this.metadataToUpdate = builder.metadataToUpdate;
        this.keysToDelete = builder.keysToDelete;
    }

    public final String opsMetadataArn() {
        return this.opsMetadataArn;
    }

    public final boolean hasMetadataToUpdate() {
        return this.metadataToUpdate != null && !(this.metadataToUpdate instanceof SdkAutoConstructMap);
    }

    public final Map<String, MetadataValue> metadataToUpdate() {
        return this.metadataToUpdate;
    }

    public final boolean hasKeysToDelete() {
        return this.keysToDelete != null && !(this.keysToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> keysToDelete() {
        return this.keysToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.opsMetadataArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataToUpdate() ? this.metadataToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeysToDelete() ? this.keysToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpsMetadataRequest)) {
            return false;
        }
        UpdateOpsMetadataRequest other = (UpdateOpsMetadataRequest)((Object)obj);
        return Objects.equals(this.opsMetadataArn(), other.opsMetadataArn()) && this.hasMetadataToUpdate() == other.hasMetadataToUpdate() && Objects.equals(this.metadataToUpdate(), other.metadataToUpdate()) && this.hasKeysToDelete() == other.hasKeysToDelete() && Objects.equals(this.keysToDelete(), other.keysToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOpsMetadataRequest").add("OpsMetadataArn", (Object)this.opsMetadataArn()).add("MetadataToUpdate", this.hasMetadataToUpdate() ? this.metadataToUpdate() : null).add("KeysToDelete", this.hasKeysToDelete() ? this.keysToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsMetadataArn": {
                return Optional.ofNullable(clazz.cast(this.opsMetadataArn()));
            }
            case "MetadataToUpdate": {
                return Optional.ofNullable(clazz.cast(this.metadataToUpdate()));
            }
            case "KeysToDelete": {
                return Optional.ofNullable(clazz.cast(this.keysToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OpsMetadataArn", OPS_METADATA_ARN_FIELD);
        map.put("MetadataToUpdate", METADATA_TO_UPDATE_FIELD);
        map.put("KeysToDelete", KEYS_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpsMetadataRequest, T> g) {
        return obj -> g.apply((UpdateOpsMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String opsMetadataArn;
        private Map<String, MetadataValue> metadataToUpdate = DefaultSdkAutoConstructMap.getInstance();
        private List<String> keysToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpsMetadataRequest model) {
            super(model);
            this.opsMetadataArn(model.opsMetadataArn);
            this.metadataToUpdate(model.metadataToUpdate);
            this.keysToDelete(model.keysToDelete);
        }

        public final String getOpsMetadataArn() {
            return this.opsMetadataArn;
        }

        public final void setOpsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
        }

        @Override
        public final Builder opsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
            return this;
        }

        public final Map<String, MetadataValue.Builder> getMetadataToUpdate() {
            Map<String, MetadataValue.Builder> result = MetadataMapCopier.copyToBuilder(this.metadataToUpdate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetadataToUpdate(Map<String, MetadataValue.BuilderImpl> metadataToUpdate) {
            this.metadataToUpdate = MetadataMapCopier.copyFromBuilder(metadataToUpdate);
        }

        @Override
        public final Builder metadataToUpdate(Map<String, MetadataValue> metadataToUpdate) {
            this.metadataToUpdate = MetadataMapCopier.copy(metadataToUpdate);
            return this;
        }

        public final Collection<String> getKeysToDelete() {
            if (this.keysToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keysToDelete;
        }

        public final void setKeysToDelete(Collection<String> keysToDelete) {
            this.keysToDelete = MetadataKeysToDeleteListCopier.copy(keysToDelete);
        }

        @Override
        public final Builder keysToDelete(Collection<String> keysToDelete) {
            this.keysToDelete = MetadataKeysToDeleteListCopier.copy(keysToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keysToDelete(String ... keysToDelete) {
            this.keysToDelete(Arrays.asList(keysToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOpsMetadataRequest build() {
            return new UpdateOpsMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOpsMetadataRequest> {
        public Builder opsMetadataArn(String var1);

        public Builder metadataToUpdate(Map<String, MetadataValue> var1);

        public Builder keysToDelete(Collection<String> var1);

        public Builder keysToDelete(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

