/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachVolumeRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DetachVolumeRequest> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeARN").getter(DetachVolumeRequest.getter(DetachVolumeRequest::volumeARN)).setter(DetachVolumeRequest.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<Boolean> FORCE_DETACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceDetach").getter(DetachVolumeRequest.getter(DetachVolumeRequest::forceDetach)).setter(DetachVolumeRequest.setter(Builder::forceDetach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceDetach").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, FORCE_DETACH_FIELD));
    private final String volumeARN;
    private final Boolean forceDetach;

    private DetachVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.forceDetach = builder.forceDetach;
    }

    public String volumeARN() {
        return this.volumeARN;
    }

    public Boolean forceDetach() {
        return this.forceDetach;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDetach());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVolumeRequest)) {
            return false;
        }
        DetachVolumeRequest other = (DetachVolumeRequest)((Object)obj);
        return Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.forceDetach(), other.forceDetach());
    }

    public String toString() {
        return ToString.builder((String)"DetachVolumeRequest").add("VolumeARN", (Object)this.volumeARN()).add("ForceDetach", (Object)this.forceDetach()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "ForceDetach": {
                return Optional.ofNullable(clazz.cast(this.forceDetach()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachVolumeRequest, T> g) {
        return obj -> g.apply((DetachVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String volumeARN;
        private Boolean forceDetach;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVolumeRequest model) {
            super(model);
            this.volumeARN(model.volumeARN);
            this.forceDetach(model.forceDetach);
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Boolean getForceDetach() {
            return this.forceDetach;
        }

        @Override
        public final Builder forceDetach(Boolean forceDetach) {
            this.forceDetach = forceDetach;
            return this;
        }

        public final void setForceDetach(Boolean forceDetach) {
            this.forceDetach = forceDetach;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachVolumeRequest build() {
            return new DetachVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetachVolumeRequest> {
        public Builder volumeARN(String var1);

        public Builder forceDetach(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

