/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HostEnvironment {
    VMWARE("VMWARE"),
    HYPER_V("HYPER-V"),
    EC2("EC2"),
    KVM("KVM"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HostEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HostEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HostEnvironment.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HostEnvironment> knownValues() {
        return Stream.of(HostEnvironment.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

