/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FileShareInfo;
import software.amazon.awssdk.services.storagegateway.model.FileShareInfoListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFileSharesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListFileSharesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListFileSharesResponse.getter(ListFileSharesResponse::marker)).setter(ListFileSharesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListFileSharesResponse.getter(ListFileSharesResponse::nextMarker)).setter(ListFileSharesResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<FileShareInfo>> FILE_SHARE_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileShareInfoList").getter(ListFileSharesResponse.getter(ListFileSharesResponse::fileShareInfoList)).setter(ListFileSharesResponse.setter(Builder::fileShareInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileShareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, NEXT_MARKER_FIELD, FILE_SHARE_INFO_LIST_FIELD));
    private final String marker;
    private final String nextMarker;
    private final List<FileShareInfo> fileShareInfoList;

    private ListFileSharesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.fileShareInfoList = builder.fileShareInfoList;
    }

    public String marker() {
        return this.marker;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public boolean hasFileShareInfoList() {
        return this.fileShareInfoList != null && !(this.fileShareInfoList instanceof SdkAutoConstructList);
    }

    public List<FileShareInfo> fileShareInfoList() {
        return this.fileShareInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileShareInfoList() ? this.fileShareInfoList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileSharesResponse)) {
            return false;
        }
        ListFileSharesResponse other = (ListFileSharesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasFileShareInfoList() == other.hasFileShareInfoList() && Objects.equals(this.fileShareInfoList(), other.fileShareInfoList());
    }

    public String toString() {
        return ToString.builder((String)"ListFileSharesResponse").add("Marker", (Object)this.marker()).add("NextMarker", (Object)this.nextMarker()).add("FileShareInfoList", this.hasFileShareInfoList() ? this.fileShareInfoList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "FileShareInfoList": {
                return Optional.ofNullable(clazz.cast(this.fileShareInfoList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFileSharesResponse, T> g) {
        return obj -> g.apply((ListFileSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String marker;
        private String nextMarker;
        private List<FileShareInfo> fileShareInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileSharesResponse model) {
            super(model);
            this.marker(model.marker);
            this.nextMarker(model.nextMarker);
            this.fileShareInfoList(model.fileShareInfoList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<FileShareInfo.Builder> getFileShareInfoList() {
            if (this.fileShareInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileShareInfoList != null ? (Collection)this.fileShareInfoList.stream().map(FileShareInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileShareInfoList(Collection<FileShareInfo> fileShareInfoList) {
            this.fileShareInfoList = FileShareInfoListCopier.copy(fileShareInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileShareInfoList(FileShareInfo ... fileShareInfoList) {
            this.fileShareInfoList(Arrays.asList(fileShareInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileShareInfoList(Consumer<FileShareInfo.Builder> ... fileShareInfoList) {
            this.fileShareInfoList(Stream.of(fileShareInfoList).map(c -> (FileShareInfo)((FileShareInfo.Builder)FileShareInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileShareInfoList(Collection<FileShareInfo.BuilderImpl> fileShareInfoList) {
            this.fileShareInfoList = FileShareInfoListCopier.copyFromBuilder(fileShareInfoList);
        }

        @Override
        public ListFileSharesResponse build() {
            return new ListFileSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFileSharesResponse> {
        public Builder marker(String var1);

        public Builder nextMarker(String var1);

        public Builder fileShareInfoList(Collection<FileShareInfo> var1);

        public Builder fileShareInfoList(FileShareInfo ... var1);

        public Builder fileShareInfoList(Consumer<FileShareInfo.Builder> ... var1);
    }
}

