/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfo;
import software.amazon.awssdk.services.storagegateway.model.VolumeRecoveryPointInfosCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVolumeRecoveryPointsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListVolumeRecoveryPointsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(ListVolumeRecoveryPointsResponse.getter(ListVolumeRecoveryPointsResponse::gatewayARN)).setter(ListVolumeRecoveryPointsResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<VolumeRecoveryPointInfo>> VOLUME_RECOVERY_POINT_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VolumeRecoveryPointInfos").getter(ListVolumeRecoveryPointsResponse.getter(ListVolumeRecoveryPointsResponse::volumeRecoveryPointInfos)).setter(ListVolumeRecoveryPointsResponse.setter(Builder::volumeRecoveryPointInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeRecoveryPointInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeRecoveryPointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, VOLUME_RECOVERY_POINT_INFOS_FIELD));
    private final String gatewayARN;
    private final List<VolumeRecoveryPointInfo> volumeRecoveryPointInfos;

    private ListVolumeRecoveryPointsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.volumeRecoveryPointInfos = builder.volumeRecoveryPointInfos;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public boolean hasVolumeRecoveryPointInfos() {
        return this.volumeRecoveryPointInfos != null && !(this.volumeRecoveryPointInfos instanceof SdkAutoConstructList);
    }

    public List<VolumeRecoveryPointInfo> volumeRecoveryPointInfos() {
        return this.volumeRecoveryPointInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeRecoveryPointInfos() ? this.volumeRecoveryPointInfos() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumeRecoveryPointsResponse)) {
            return false;
        }
        ListVolumeRecoveryPointsResponse other = (ListVolumeRecoveryPointsResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasVolumeRecoveryPointInfos() == other.hasVolumeRecoveryPointInfos() && Objects.equals(this.volumeRecoveryPointInfos(), other.volumeRecoveryPointInfos());
    }

    public String toString() {
        return ToString.builder((String)"ListVolumeRecoveryPointsResponse").add("GatewayARN", (Object)this.gatewayARN()).add("VolumeRecoveryPointInfos", this.hasVolumeRecoveryPointInfos() ? this.volumeRecoveryPointInfos() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "VolumeRecoveryPointInfos": {
                return Optional.ofNullable(clazz.cast(this.volumeRecoveryPointInfos()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVolumeRecoveryPointsResponse, T> g) {
        return obj -> g.apply((ListVolumeRecoveryPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<VolumeRecoveryPointInfo> volumeRecoveryPointInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumeRecoveryPointsResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.volumeRecoveryPointInfos(model.volumeRecoveryPointInfos);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<VolumeRecoveryPointInfo.Builder> getVolumeRecoveryPointInfos() {
            if (this.volumeRecoveryPointInfos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.volumeRecoveryPointInfos != null ? (Collection)this.volumeRecoveryPointInfos.stream().map(VolumeRecoveryPointInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeRecoveryPointInfos(Collection<VolumeRecoveryPointInfo> volumeRecoveryPointInfos) {
            this.volumeRecoveryPointInfos = VolumeRecoveryPointInfosCopier.copy(volumeRecoveryPointInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecoveryPointInfos(VolumeRecoveryPointInfo ... volumeRecoveryPointInfos) {
            this.volumeRecoveryPointInfos(Arrays.asList(volumeRecoveryPointInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecoveryPointInfos(Consumer<VolumeRecoveryPointInfo.Builder> ... volumeRecoveryPointInfos) {
            this.volumeRecoveryPointInfos(Stream.of(volumeRecoveryPointInfos).map(c -> (VolumeRecoveryPointInfo)((VolumeRecoveryPointInfo.Builder)VolumeRecoveryPointInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeRecoveryPointInfos(Collection<VolumeRecoveryPointInfo.BuilderImpl> volumeRecoveryPointInfos) {
            this.volumeRecoveryPointInfos = VolumeRecoveryPointInfosCopier.copyFromBuilder(volumeRecoveryPointInfos);
        }

        @Override
        public ListVolumeRecoveryPointsResponse build() {
            return new ListVolumeRecoveryPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVolumeRecoveryPointsResponse> {
        public Builder gatewayARN(String var1);

        public Builder volumeRecoveryPointInfos(Collection<VolumeRecoveryPointInfo> var1);

        public Builder volumeRecoveryPointInfos(VolumeRecoveryPointInfo ... var1);

        public Builder volumeRecoveryPointInfos(Consumer<VolumeRecoveryPointInfo.Builder> ... var1);
    }
}

