/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;

public class ListOpenWorkflowExecutionsIterable
implements SdkIterable<ListOpenWorkflowExecutionsResponse> {
    private final SwfClient client;
    private final ListOpenWorkflowExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpenWorkflowExecutionsIterable(SwfClient client, ListOpenWorkflowExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOpenWorkflowExecutionsResponseFetcher();
    }

    public Iterator<ListOpenWorkflowExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowExecutionInfo> executionInfos() {
        Function<ListOpenWorkflowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionInfos() != null) {
                return response.executionInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpenWorkflowExecutionsResponseFetcher
    implements SyncPageFetcher<ListOpenWorkflowExecutionsResponse> {
        private ListOpenWorkflowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpenWorkflowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListOpenWorkflowExecutionsResponse nextPage(ListOpenWorkflowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListOpenWorkflowExecutionsIterable.this.client.listOpenWorkflowExecutions(ListOpenWorkflowExecutionsIterable.this.firstRequest);
            }
            return ListOpenWorkflowExecutionsIterable.this.client.listOpenWorkflowExecutions((ListOpenWorkflowExecutionsRequest)((Object)ListOpenWorkflowExecutionsIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

