/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties;
import software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableRequest
extends TimestreamWriteRequest
implements ToCopyableBuilder<Builder, UpdateTableRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(UpdateTableRequest.getter(UpdateTableRequest::databaseName)).setter(UpdateTableRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdateTableRequest.getter(UpdateTableRequest::tableName)).setter(UpdateTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<RetentionProperties> RETENTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionProperties").getter(UpdateTableRequest.getter(UpdateTableRequest::retentionProperties)).setter(UpdateTableRequest.setter(Builder::retentionProperties)).constructor(RetentionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionProperties").build()}).build();
    private static final SdkField<MagneticStoreWriteProperties> MAGNETIC_STORE_WRITE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MagneticStoreWriteProperties").getter(UpdateTableRequest.getter(UpdateTableRequest::magneticStoreWriteProperties)).setter(UpdateTableRequest.setter(Builder::magneticStoreWriteProperties)).constructor(MagneticStoreWriteProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreWriteProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLE_NAME_FIELD, RETENTION_PROPERTIES_FIELD, MAGNETIC_STORE_WRITE_PROPERTIES_FIELD));
    private final String databaseName;
    private final String tableName;
    private final RetentionProperties retentionProperties;
    private final MagneticStoreWriteProperties magneticStoreWriteProperties;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.retentionProperties = builder.retentionProperties;
        this.magneticStoreWriteProperties = builder.magneticStoreWriteProperties;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final RetentionProperties retentionProperties() {
        return this.retentionProperties;
    }

    public final MagneticStoreWriteProperties magneticStoreWriteProperties() {
        return this.magneticStoreWriteProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.magneticStoreWriteProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)((Object)obj);
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.retentionProperties(), other.retentionProperties()) && Objects.equals(this.magneticStoreWriteProperties(), other.magneticStoreWriteProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTableRequest").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("RetentionProperties", (Object)this.retentionProperties()).add("MagneticStoreWriteProperties", (Object)this.magneticStoreWriteProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "RetentionProperties": {
                return Optional.ofNullable(clazz.cast(this.retentionProperties()));
            }
            case "MagneticStoreWriteProperties": {
                return Optional.ofNullable(clazz.cast(this.magneticStoreWriteProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamWriteRequest.BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;
        private RetentionProperties retentionProperties;
        private MagneticStoreWriteProperties magneticStoreWriteProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.retentionProperties(model.retentionProperties);
            this.magneticStoreWriteProperties(model.magneticStoreWriteProperties);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final RetentionProperties.Builder getRetentionProperties() {
            return this.retentionProperties != null ? this.retentionProperties.toBuilder() : null;
        }

        public final void setRetentionProperties(RetentionProperties.BuilderImpl retentionProperties) {
            this.retentionProperties = retentionProperties != null ? retentionProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder retentionProperties(RetentionProperties retentionProperties) {
            this.retentionProperties = retentionProperties;
            return this;
        }

        public final MagneticStoreWriteProperties.Builder getMagneticStoreWriteProperties() {
            return this.magneticStoreWriteProperties != null ? this.magneticStoreWriteProperties.toBuilder() : null;
        }

        public final void setMagneticStoreWriteProperties(MagneticStoreWriteProperties.BuilderImpl magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties != null ? magneticStoreWriteProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TimestreamWriteRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableRequest> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder retentionProperties(RetentionProperties var1);

        default public Builder retentionProperties(Consumer<RetentionProperties.Builder> retentionProperties) {
            return this.retentionProperties((RetentionProperties)((RetentionProperties.Builder)RetentionProperties.builder().applyMutation(retentionProperties)).build());
        }

        public Builder magneticStoreWriteProperties(MagneticStoreWriteProperties var1);

        default public Builder magneticStoreWriteProperties(Consumer<MagneticStoreWriteProperties.Builder> magneticStoreWriteProperties) {
            return this.magneticStoreWriteProperties((MagneticStoreWriteProperties)((MagneticStoreWriteProperties.Builder)MagneticStoreWriteProperties.builder().applyMutation(magneticStoreWriteProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

