/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MediaFormat {
    MP3("mp3"),
    MP4("mp4"),
    WAV("wav"),
    FLAC("flac"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MediaFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MediaFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaFormat> knownValues() {
        return Stream.of(MediaFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

