/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.ModelStatus;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLanguageModelsRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, ListLanguageModelsRequest> {
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusEquals").getter(ListLanguageModelsRequest.getter(ListLanguageModelsRequest::statusEqualsAsString)).setter(ListLanguageModelsRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListLanguageModelsRequest.getter(ListLanguageModelsRequest::nameContains)).setter(ListLanguageModelsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLanguageModelsRequest.getter(ListLanguageModelsRequest::nextToken)).setter(ListLanguageModelsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListLanguageModelsRequest.getter(ListLanguageModelsRequest::maxResults)).setter(ListLanguageModelsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_EQUALS_FIELD, NAME_CONTAINS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String statusEquals;
    private final String nameContains;
    private final String nextToken;
    private final Integer maxResults;

    private ListLanguageModelsRequest(BuilderImpl builder) {
        super(builder);
        this.statusEquals = builder.statusEquals;
        this.nameContains = builder.nameContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public ModelStatus statusEquals() {
        return ModelStatus.fromValue(this.statusEquals);
    }

    public String statusEqualsAsString() {
        return this.statusEquals;
    }

    public String nameContains() {
        return this.nameContains;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguageModelsRequest)) {
            return false;
        }
        ListLanguageModelsRequest other = (ListLanguageModelsRequest)((Object)obj);
        return Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListLanguageModelsRequest").add("StatusEquals", (Object)this.statusEqualsAsString()).add("NameContains", (Object)this.nameContains()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLanguageModelsRequest, T> g) {
        return obj -> g.apply((ListLanguageModelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String statusEquals;
        private String nameContains;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguageModelsRequest model) {
            super(model);
            this.statusEquals(model.statusEquals);
            this.nameContains(model.nameContains);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ModelStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLanguageModelsRequest build() {
            return new ListLanguageModelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLanguageModelsRequest> {
        public Builder statusEquals(String var1);

        public Builder statusEquals(ModelStatus var1);

        public Builder nameContains(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

