/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.services.transcribe.model.VocabularyState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMedicalVocabularyResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, CreateMedicalVocabularyResponse> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(CreateMedicalVocabularyResponse.getter(CreateMedicalVocabularyResponse::vocabularyName)).setter(CreateMedicalVocabularyResponse.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CreateMedicalVocabularyResponse.getter(CreateMedicalVocabularyResponse::languageCodeAsString)).setter(CreateMedicalVocabularyResponse.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyState").getter(CreateMedicalVocabularyResponse.getter(CreateMedicalVocabularyResponse::vocabularyStateAsString)).setter(CreateMedicalVocabularyResponse.setter(Builder::vocabularyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyState").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(CreateMedicalVocabularyResponse.getter(CreateMedicalVocabularyResponse::lastModifiedTime)).setter(CreateMedicalVocabularyResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(CreateMedicalVocabularyResponse.getter(CreateMedicalVocabularyResponse::failureReason)).setter(CreateMedicalVocabularyResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, LANGUAGE_CODE_FIELD, VOCABULARY_STATE_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD));
    private final String vocabularyName;
    private final String languageCode;
    private final String vocabularyState;
    private final Instant lastModifiedTime;
    private final String failureReason;

    private CreateMedicalVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.vocabularyState = builder.vocabularyState;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final VocabularyState vocabularyState() {
        return VocabularyState.fromValue(this.vocabularyState);
    }

    public final String vocabularyStateAsString() {
        return this.vocabularyState;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMedicalVocabularyResponse)) {
            return false;
        }
        CreateMedicalVocabularyResponse other = (CreateMedicalVocabularyResponse)((Object)obj);
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyStateAsString(), other.vocabularyStateAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMedicalVocabularyResponse").add("VocabularyName", (Object)this.vocabularyName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyState", (Object)this.vocabularyStateAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyState": {
                return Optional.ofNullable(clazz.cast(this.vocabularyStateAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMedicalVocabularyResponse, T> g) {
        return obj -> g.apply((CreateMedicalVocabularyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String languageCode;
        private String vocabularyState;
        private Instant lastModifiedTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMedicalVocabularyResponse model) {
            super(model);
            this.vocabularyName(model.vocabularyName);
            this.languageCode(model.languageCode);
            this.vocabularyState(model.vocabularyState);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyState() {
            return this.vocabularyState;
        }

        public final void setVocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
        }

        @Override
        public final Builder vocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
            return this;
        }

        @Override
        public final Builder vocabularyState(VocabularyState vocabularyState) {
            this.vocabularyState(vocabularyState == null ? null : vocabularyState.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public CreateMedicalVocabularyResponse build() {
            return new CreateMedicalVocabularyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMedicalVocabularyResponse> {
        public Builder vocabularyName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder vocabularyState(String var1);

        public Builder vocabularyState(VocabularyState var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

