/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse;

public class ListMedicalVocabulariesIterable
implements SdkIterable<ListMedicalVocabulariesResponse> {
    private final TranscribeClient client;
    private final ListMedicalVocabulariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMedicalVocabulariesIterable(TranscribeClient client, ListMedicalVocabulariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMedicalVocabulariesResponseFetcher();
    }

    public Iterator<ListMedicalVocabulariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMedicalVocabulariesResponseFetcher
    implements SyncPageFetcher<ListMedicalVocabulariesResponse> {
        private ListMedicalVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(ListMedicalVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMedicalVocabulariesResponse nextPage(ListMedicalVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return ListMedicalVocabulariesIterable.this.client.listMedicalVocabularies(ListMedicalVocabulariesIterable.this.firstRequest);
            }
            return ListMedicalVocabulariesIterable.this.client.listMedicalVocabularies((ListMedicalVocabulariesRequest)((Object)ListMedicalVocabulariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

