/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.ContentRedaction;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.LanguageOptionsCopier;
import software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CallAnalyticsJobSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CallAnalyticsJobSettings> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(CallAnalyticsJobSettings.getter(CallAnalyticsJobSettings::vocabularyName)).setter(CallAnalyticsJobSettings.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(CallAnalyticsJobSettings.getter(CallAnalyticsJobSettings::vocabularyFilterName)).setter(CallAnalyticsJobSettings.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(CallAnalyticsJobSettings.getter(CallAnalyticsJobSettings::vocabularyFilterMethodAsString)).setter(CallAnalyticsJobSettings.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<String> LANGUAGE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageModelName").getter(CallAnalyticsJobSettings.getter(CallAnalyticsJobSettings::languageModelName)).setter(CallAnalyticsJobSettings.setter(Builder::languageModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModelName").build()}).build();
    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentRedaction").getter(CallAnalyticsJobSettings.getter(CallAnalyticsJobSettings::contentRedaction)).setter(CallAnalyticsJobSettings.setter(Builder::contentRedaction)).constructor(ContentRedaction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()}).build();
    private static final SdkField<List<String>> LANGUAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LanguageOptions").getter(CallAnalyticsJobSettings.getter(CallAnalyticsJobSettings::languageOptionsAsStrings)).setter(CallAnalyticsJobSettings.setter(Builder::languageOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, LANGUAGE_MODEL_NAME_FIELD, CONTENT_REDACTION_FIELD, LANGUAGE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vocabularyName;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final String languageModelName;
    private final ContentRedaction contentRedaction;
    private final List<String> languageOptions;

    private CallAnalyticsJobSettings(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.languageModelName = builder.languageModelName;
        this.contentRedaction = builder.contentRedaction;
        this.languageOptions = builder.languageOptions;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final String languageModelName() {
        return this.languageModelName;
    }

    public final ContentRedaction contentRedaction() {
        return this.contentRedaction;
    }

    public final List<LanguageCode> languageOptions() {
        return LanguageOptionsCopier.copyStringToEnum(this.languageOptions);
    }

    public final boolean hasLanguageOptions() {
        return this.languageOptions != null && !(this.languageOptions instanceof SdkAutoConstructList);
    }

    public final List<String> languageOptionsAsStrings() {
        return this.languageOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguageOptions() ? this.languageOptionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsJobSettings)) {
            return false;
        }
        CallAnalyticsJobSettings other = (CallAnalyticsJobSettings)obj;
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.languageModelName(), other.languageModelName()) && Objects.equals(this.contentRedaction(), other.contentRedaction()) && this.hasLanguageOptions() == other.hasLanguageOptions() && Objects.equals(this.languageOptionsAsStrings(), other.languageOptionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CallAnalyticsJobSettings").add("VocabularyName", (Object)this.vocabularyName()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("LanguageModelName", (Object)this.languageModelName()).add("ContentRedaction", (Object)this.contentRedaction()).add("LanguageOptions", this.hasLanguageOptions() ? this.languageOptionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "LanguageModelName": {
                return Optional.ofNullable(clazz.cast(this.languageModelName()));
            }
            case "ContentRedaction": {
                return Optional.ofNullable(clazz.cast(this.contentRedaction()));
            }
            case "LanguageOptions": {
                return Optional.ofNullable(clazz.cast(this.languageOptionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsJobSettings, T> g) {
        return obj -> g.apply((CallAnalyticsJobSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private String languageModelName;
        private ContentRedaction contentRedaction;
        private List<String> languageOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsJobSettings model) {
            this.vocabularyName(model.vocabularyName);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.languageModelName(model.languageModelName);
            this.contentRedaction(model.contentRedaction);
            this.languageOptionsWithStrings(model.languageOptions);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getLanguageModelName() {
            return this.languageModelName;
        }

        public final void setLanguageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
        }

        @Override
        @Transient
        public final Builder languageModelName(String languageModelName) {
            this.languageModelName = languageModelName;
            return this;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return this.contentRedaction != null ? this.contentRedaction.toBuilder() : null;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        @Override
        @Transient
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final Collection<String> getLanguageOptions() {
            if (this.languageOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.languageOptions;
        }

        public final void setLanguageOptions(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
        }

        @Override
        @Transient
        public final Builder languageOptionsWithStrings(Collection<String> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copy(languageOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder languageOptionsWithStrings(String ... languageOptions) {
            this.languageOptionsWithStrings(Arrays.asList(languageOptions));
            return this;
        }

        @Override
        @Transient
        public final Builder languageOptions(Collection<LanguageCode> languageOptions) {
            this.languageOptions = LanguageOptionsCopier.copyEnumToString(languageOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder languageOptions(LanguageCode ... languageOptions) {
            this.languageOptions(Arrays.asList(languageOptions));
            return this;
        }

        public CallAnalyticsJobSettings build() {
            return new CallAnalyticsJobSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CallAnalyticsJobSettings> {
        public Builder vocabularyName(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);

        public Builder languageModelName(String var1);

        public Builder contentRedaction(ContentRedaction var1);

        default public Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return this.contentRedaction((ContentRedaction)((ContentRedaction.Builder)ContentRedaction.builder().applyMutation(contentRedaction)).build());
        }

        public Builder languageOptionsWithStrings(Collection<String> var1);

        public Builder languageOptionsWithStrings(String ... var1);

        public Builder languageOptions(Collection<LanguageCode> var1);

        public Builder languageOptions(LanguageCode ... var1);
    }
}

