/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LanguageCode {
    AF_ZA("af-ZA"),
    AR_AE("ar-AE"),
    AR_SA("ar-SA"),
    CY_GB("cy-GB"),
    DA_DK("da-DK"),
    DE_CH("de-CH"),
    DE_DE("de-DE"),
    EN_AB("en-AB"),
    EN_AU("en-AU"),
    EN_GB("en-GB"),
    EN_IE("en-IE"),
    EN_IN("en-IN"),
    EN_US("en-US"),
    EN_WL("en-WL"),
    ES_ES("es-ES"),
    ES_US("es-US"),
    FA_IR("fa-IR"),
    FR_CA("fr-CA"),
    FR_FR("fr-FR"),
    GA_IE("ga-IE"),
    GD_GB("gd-GB"),
    HE_IL("he-IL"),
    HI_IN("hi-IN"),
    ID_ID("id-ID"),
    IT_IT("it-IT"),
    JA_JP("ja-JP"),
    KO_KR("ko-KR"),
    MS_MY("ms-MY"),
    NL_NL("nl-NL"),
    PT_BR("pt-BR"),
    PT_PT("pt-PT"),
    RU_RU("ru-RU"),
    TA_IN("ta-IN"),
    TE_IN("te-IN"),
    TR_TR("tr-TR"),
    ZH_CN("zh-CN"),
    ZH_TW("zh-TW"),
    TH_TH("th-TH"),
    EN_ZA("en-ZA"),
    EN_NZ("en-NZ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageCode> VALUE_MAP;
    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCode> knownValues() {
        EnumSet<LanguageCode> knownValues = EnumSet.allOf(LanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LanguageCode.class, LanguageCode::toString);
    }
}

