/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.services.transcribe.model.VocabularyFilterInfo;
import software.amazon.awssdk.services.transcribe.model.VocabularyFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVocabularyFiltersResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListVocabularyFiltersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVocabularyFiltersResponse.getter(ListVocabularyFiltersResponse::nextToken)).setter(ListVocabularyFiltersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<VocabularyFilterInfo>> VOCABULARY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VocabularyFilters").getter(ListVocabularyFiltersResponse.getter(ListVocabularyFiltersResponse::vocabularyFilters)).setter(ListVocabularyFiltersResponse.setter(Builder::vocabularyFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VocabularyFilterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VOCABULARY_FILTERS_FIELD));
    private final String nextToken;
    private final List<VocabularyFilterInfo> vocabularyFilters;

    private ListVocabularyFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vocabularyFilters = builder.vocabularyFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVocabularyFilters() {
        return this.vocabularyFilters != null && !(this.vocabularyFilters instanceof SdkAutoConstructList);
    }

    public final List<VocabularyFilterInfo> vocabularyFilters() {
        return this.vocabularyFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVocabularyFilters() ? this.vocabularyFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabularyFiltersResponse)) {
            return false;
        }
        ListVocabularyFiltersResponse other = (ListVocabularyFiltersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVocabularyFilters() == other.hasVocabularyFilters() && Objects.equals(this.vocabularyFilters(), other.vocabularyFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ListVocabularyFiltersResponse").add("NextToken", (Object)this.nextToken()).add("VocabularyFilters", this.hasVocabularyFilters() ? this.vocabularyFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VocabularyFilters": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVocabularyFiltersResponse, T> g) {
        return obj -> g.apply((ListVocabularyFiltersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VocabularyFilterInfo> vocabularyFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVocabularyFiltersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vocabularyFilters(model.vocabularyFilters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VocabularyFilterInfo.Builder> getVocabularyFilters() {
            List<VocabularyFilterInfo.Builder> result = VocabularyFiltersCopier.copyToBuilder(this.vocabularyFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVocabularyFilters(Collection<VocabularyFilterInfo.BuilderImpl> vocabularyFilters) {
            this.vocabularyFilters = VocabularyFiltersCopier.copyFromBuilder(vocabularyFilters);
        }

        @Override
        @Transient
        public final Builder vocabularyFilters(Collection<VocabularyFilterInfo> vocabularyFilters) {
            this.vocabularyFilters = VocabularyFiltersCopier.copy(vocabularyFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vocabularyFilters(VocabularyFilterInfo ... vocabularyFilters) {
            this.vocabularyFilters(Arrays.asList(vocabularyFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vocabularyFilters(Consumer<VocabularyFilterInfo.Builder> ... vocabularyFilters) {
            this.vocabularyFilters(Stream.of(vocabularyFilters).map(c -> (VocabularyFilterInfo)((VocabularyFilterInfo.Builder)VocabularyFilterInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVocabularyFiltersResponse build() {
            return new ListVocabularyFiltersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVocabularyFiltersResponse> {
        public Builder nextToken(String var1);

        public Builder vocabularyFilters(Collection<VocabularyFilterInfo> var1);

        public Builder vocabularyFilters(VocabularyFilterInfo ... var1);

        public Builder vocabularyFilters(Consumer<VocabularyFilterInfo.Builder> ... var1);
    }
}

