/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.InterruptionFilter;
import software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter;
import software.amazon.awssdk.services.transcribe.model.SentimentFilter;
import software.amazon.awssdk.services.transcribe.model.TranscriptFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<NonTalkTimeFilter> NON_TALK_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NonTalkTimeFilter").getter(Rule.getter(Rule::nonTalkTimeFilter)).setter(Rule.setter(Builder::nonTalkTimeFilter)).constructor(NonTalkTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonTalkTimeFilter").build()}).build();
    private static final SdkField<InterruptionFilter> INTERRUPTION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InterruptionFilter").getter(Rule.getter(Rule::interruptionFilter)).setter(Rule.setter(Builder::interruptionFilter)).constructor(InterruptionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionFilter").build()}).build();
    private static final SdkField<TranscriptFilter> TRANSCRIPT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TranscriptFilter").getter(Rule.getter(Rule::transcriptFilter)).setter(Rule.setter(Builder::transcriptFilter)).constructor(TranscriptFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFilter").build()}).build();
    private static final SdkField<SentimentFilter> SENTIMENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SentimentFilter").getter(Rule.getter(Rule::sentimentFilter)).setter(Rule.setter(Builder::sentimentFilter)).constructor(SentimentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_TALK_TIME_FILTER_FIELD, INTERRUPTION_FILTER_FIELD, TRANSCRIPT_FILTER_FIELD, SENTIMENT_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final NonTalkTimeFilter nonTalkTimeFilter;
    private final InterruptionFilter interruptionFilter;
    private final TranscriptFilter transcriptFilter;
    private final SentimentFilter sentimentFilter;

    private Rule(BuilderImpl builder) {
        this.nonTalkTimeFilter = builder.nonTalkTimeFilter;
        this.interruptionFilter = builder.interruptionFilter;
        this.transcriptFilter = builder.transcriptFilter;
        this.sentimentFilter = builder.sentimentFilter;
    }

    public final NonTalkTimeFilter nonTalkTimeFilter() {
        return this.nonTalkTimeFilter;
    }

    public final InterruptionFilter interruptionFilter() {
        return this.interruptionFilter;
    }

    public final TranscriptFilter transcriptFilter() {
        return this.transcriptFilter;
    }

    public final SentimentFilter sentimentFilter() {
        return this.sentimentFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nonTalkTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.interruptionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.nonTalkTimeFilter(), other.nonTalkTimeFilter()) && Objects.equals(this.interruptionFilter(), other.interruptionFilter()) && Objects.equals(this.transcriptFilter(), other.transcriptFilter()) && Objects.equals(this.sentimentFilter(), other.sentimentFilter());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("NonTalkTimeFilter", (Object)this.nonTalkTimeFilter()).add("InterruptionFilter", (Object)this.interruptionFilter()).add("TranscriptFilter", (Object)this.transcriptFilter()).add("SentimentFilter", (Object)this.sentimentFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NonTalkTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.nonTalkTimeFilter()));
            }
            case "InterruptionFilter": {
                return Optional.ofNullable(clazz.cast(this.interruptionFilter()));
            }
            case "TranscriptFilter": {
                return Optional.ofNullable(clazz.cast(this.transcriptFilter()));
            }
            case "SentimentFilter": {
                return Optional.ofNullable(clazz.cast(this.sentimentFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NonTalkTimeFilter nonTalkTimeFilter;
        private InterruptionFilter interruptionFilter;
        private TranscriptFilter transcriptFilter;
        private SentimentFilter sentimentFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.nonTalkTimeFilter(model.nonTalkTimeFilter);
            this.interruptionFilter(model.interruptionFilter);
            this.transcriptFilter(model.transcriptFilter);
            this.sentimentFilter(model.sentimentFilter);
        }

        public final NonTalkTimeFilter.Builder getNonTalkTimeFilter() {
            return this.nonTalkTimeFilter != null ? this.nonTalkTimeFilter.toBuilder() : null;
        }

        public final void setNonTalkTimeFilter(NonTalkTimeFilter.BuilderImpl nonTalkTimeFilter) {
            this.nonTalkTimeFilter = nonTalkTimeFilter != null ? nonTalkTimeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder nonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter) {
            this.nonTalkTimeFilter = nonTalkTimeFilter;
            return this;
        }

        public final InterruptionFilter.Builder getInterruptionFilter() {
            return this.interruptionFilter != null ? this.interruptionFilter.toBuilder() : null;
        }

        public final void setInterruptionFilter(InterruptionFilter.BuilderImpl interruptionFilter) {
            this.interruptionFilter = interruptionFilter != null ? interruptionFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder interruptionFilter(InterruptionFilter interruptionFilter) {
            this.interruptionFilter = interruptionFilter;
            return this;
        }

        public final TranscriptFilter.Builder getTranscriptFilter() {
            return this.transcriptFilter != null ? this.transcriptFilter.toBuilder() : null;
        }

        public final void setTranscriptFilter(TranscriptFilter.BuilderImpl transcriptFilter) {
            this.transcriptFilter = transcriptFilter != null ? transcriptFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder transcriptFilter(TranscriptFilter transcriptFilter) {
            this.transcriptFilter = transcriptFilter;
            return this;
        }

        public final SentimentFilter.Builder getSentimentFilter() {
            return this.sentimentFilter != null ? this.sentimentFilter.toBuilder() : null;
        }

        public final void setSentimentFilter(SentimentFilter.BuilderImpl sentimentFilter) {
            this.sentimentFilter = sentimentFilter != null ? sentimentFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder sentimentFilter(SentimentFilter sentimentFilter) {
            this.sentimentFilter = sentimentFilter;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder nonTalkTimeFilter(NonTalkTimeFilter var1);

        default public Builder nonTalkTimeFilter(Consumer<NonTalkTimeFilter.Builder> nonTalkTimeFilter) {
            return this.nonTalkTimeFilter((NonTalkTimeFilter)((NonTalkTimeFilter.Builder)NonTalkTimeFilter.builder().applyMutation(nonTalkTimeFilter)).build());
        }

        public Builder interruptionFilter(InterruptionFilter var1);

        default public Builder interruptionFilter(Consumer<InterruptionFilter.Builder> interruptionFilter) {
            return this.interruptionFilter((InterruptionFilter)((InterruptionFilter.Builder)InterruptionFilter.builder().applyMutation(interruptionFilter)).build());
        }

        public Builder transcriptFilter(TranscriptFilter var1);

        default public Builder transcriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
            return this.transcriptFilter((TranscriptFilter)((TranscriptFilter.Builder)TranscriptFilter.builder().applyMutation(transcriptFilter)).build());
        }

        public Builder sentimentFilter(SentimentFilter var1);

        default public Builder sentimentFilter(Consumer<SentimentFilter.Builder> sentimentFilter) {
            return this.sentimentFilter((SentimentFilter)((SentimentFilter.Builder)SentimentFilter.builder().applyMutation(sentimentFilter)).build());
        }
    }
}

