/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.IdentifierUtils;
import software.amazon.awssdk.v2migration.internal.utils.NamingUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class NewClassToBuilder
extends Recipe {
    public String getDisplayName() {
        return "Transform 'new' expressions to builders";
    }

    public String getDescription() {
        return "Transforms 'new' expression for generated model, client objects and client config related objects to the equivalent builder()..build() expression in V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NewV1ClassToBuilderVisitor();
    }

    private static class NewV1ClassToBuilderVisitor
    extends JavaVisitor<ExecutionContext> {
        private NewV1ClassToBuilderVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation previousMethod, ExecutionContext executionContext) {
            J.MethodInvocation method = (J.MethodInvocation)super.visitMethodInvocation(previousMethod, (Object)executionContext).cast();
            if (!NamingUtils.isWither(method.getSimpleName())) {
                return method;
            }
            Expression select = method.getSelect();
            if (!(select instanceof J.MethodInvocation)) {
                return method;
            }
            J.MethodInvocation selectInvoke = (J.MethodInvocation)select;
            if (!selectInvoke.getSimpleName().equals("build")) {
                return method;
            }
            Expression selectInvokeSelect = selectInvoke.getSelect();
            J.MethodInvocation newWith = method.withSelect(selectInvokeSelect);
            return this.maybeAutoFormat((J)previousMethod, (J)selectInvoke.withSelect((Expression)newWith), executionContext);
        }

        public J visitNewClass(J.NewClass previousNewClass, ExecutionContext executionContext) {
            J.NewClass newClass = (J.NewClass)super.visitNewClass(previousNewClass, (Object)executionContext).cast();
            if (!(newClass.getType() instanceof JavaType.FullyQualified)) {
                return newClass;
            }
            JavaType.FullyQualified classType = (JavaType.FullyQualified)newClass.getType();
            if (!SdkTypeUtils.isEligibleToConvertToBuilder(classType) || !newClass.getConstructorType().getParameterNames().isEmpty()) {
                return newClass;
            }
            JavaType.FullyQualified builderType = SdkTypeUtils.v2Builder(classType);
            J.Identifier modelId = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), classType.getClassName(), (JavaType)classType, null);
            JavaType.Method methodType = new JavaType.Method(null, 0L, classType, "builder", (JavaType)builderType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            J.Identifier builderMethod = IdentifierUtils.makeId("builder", (JavaType)methodType);
            J.MethodInvocation builderInvoke = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)modelId), null, builderMethod, JContainer.empty(), methodType);
            JavaType.Method buildMethodType = new JavaType.Method(null, 0L, builderType, "build", (JavaType)classType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            J.Identifier buildName = IdentifierUtils.makeId("build", (JavaType)buildMethodType);
            J.MethodInvocation buildInvoke = new J.MethodInvocation(Tree.randomId(), newClass.getPrefix(), Markers.EMPTY, new JRightPadded((Object)builderInvoke, Space.format((String)"\n"), Markers.EMPTY), null, buildName, JContainer.empty(), buildMethodType);
            return this.maybeAutoFormat((J)previousNewClass, (J)buildInvoke, executionContext);
        }
    }
}

