/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class NumberToDuration
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="com.amazonaws.ClientConfiguration setRequestTimeout(int)")
    private final String methodPattern;
    @Option(displayName="Time Unit", description="The TimeUnit enum value to convert. Defaults to `MILLISECONDS`.", example="MILLISECONDS", required=false)
    private final TimeUnit timeUnit;

    @JsonCreator
    public NumberToDuration(@JsonProperty(value="methodPattern") String methodPattern, @JsonProperty(value="timeUnit") TimeUnit timeUnit) {
        this.methodPattern = methodPattern;
        this.timeUnit = timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
    }

    public String getDisplayName() {
        return "Convert the method parameter from numeric type to duration";
    }

    public String getDescription() {
        return "Convert the method parameter from numeric types to duration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor(this.methodPattern, this.timeUnit);
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final TimeUnit timeUnit;

        Visitor(String methodPattern, TimeUnit timeUnit) {
            this.methodMatcher = new MethodMatcher(methodPattern, false);
            this.timeUnit = timeUnit;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation methodInvocation = super.visitMethodInvocation(method, (Object)ctx);
            if (!this.methodMatcher.matches((MethodCall)methodInvocation)) {
                return methodInvocation;
            }
            String durationStr = this.durationCreationStr();
            JavaTemplate template = JavaTemplate.builder((String)(durationStr + "(#{any()})")).contextSensitive().imports(new String[]{"java.time.Duration"}).build();
            ArrayList arguments = new ArrayList(methodInvocation.getArguments());
            methodInvocation = (J.MethodInvocation)template.apply(this.updateCursor((Tree)methodInvocation), methodInvocation.getCoordinates().replaceArguments(), arguments.toArray(new Object[0]));
            this.maybeAddImport("java.time.Duration");
            return methodInvocation;
        }

        private String durationCreationStr() {
            String durationStr;
            switch (this.timeUnit) {
                case MILLISECONDS: {
                    durationStr = "Duration.ofMillis";
                    break;
                }
                case SECONDS: {
                    durationStr = "Duration.ofSeconds";
                    break;
                }
                case MINUTES: {
                    durationStr = "Duration.ofMinutes";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported time unit: " + (Object)((Object)this.timeUnit));
                }
            }
            return durationStr;
        }
    }
}

