/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.services.waf.model.XssMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.XssMatchSetSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListXssMatchSetsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListXssMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListXssMatchSetsResponse.getter(ListXssMatchSetsResponse::nextMarker)).setter(ListXssMatchSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<XssMatchSetSummary>> XSS_MATCH_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("XssMatchSets").getter(ListXssMatchSetsResponse.getter(ListXssMatchSetsResponse::xssMatchSets)).setter(ListXssMatchSetsResponse.setter(Builder::xssMatchSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(XssMatchSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, XSS_MATCH_SETS_FIELD));
    private final String nextMarker;
    private final List<XssMatchSetSummary> xssMatchSets;

    private ListXssMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.xssMatchSets = builder.xssMatchSets;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasXssMatchSets() {
        return this.xssMatchSets != null && !(this.xssMatchSets instanceof SdkAutoConstructList);
    }

    public final List<XssMatchSetSummary> xssMatchSets() {
        return this.xssMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasXssMatchSets() ? this.xssMatchSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListXssMatchSetsResponse)) {
            return false;
        }
        ListXssMatchSetsResponse other = (ListXssMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasXssMatchSets() == other.hasXssMatchSets() && Objects.equals(this.xssMatchSets(), other.xssMatchSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListXssMatchSetsResponse").add("NextMarker", (Object)this.nextMarker()).add("XssMatchSets", this.hasXssMatchSets() ? this.xssMatchSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "XssMatchSets": {
                return Optional.ofNullable(clazz.cast(this.xssMatchSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListXssMatchSetsResponse, T> g) {
        return obj -> g.apply((ListXssMatchSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<XssMatchSetSummary> xssMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListXssMatchSetsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.xssMatchSets(model.xssMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final List<XssMatchSetSummary.Builder> getXssMatchSets() {
            List<XssMatchSetSummary.Builder> result = XssMatchSetSummariesCopier.copyToBuilder(this.xssMatchSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder xssMatchSets(Collection<XssMatchSetSummary> xssMatchSets) {
            this.xssMatchSets = XssMatchSetSummariesCopier.copy(xssMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchSets(XssMatchSetSummary ... xssMatchSets) {
            this.xssMatchSets(Arrays.asList(xssMatchSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchSets(Consumer<XssMatchSetSummary.Builder> ... xssMatchSets) {
            this.xssMatchSets(Stream.of(xssMatchSets).map(c -> (XssMatchSetSummary)((XssMatchSetSummary.Builder)XssMatchSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setXssMatchSets(Collection<XssMatchSetSummary.BuilderImpl> xssMatchSets) {
            this.xssMatchSets = XssMatchSetSummariesCopier.copyFromBuilder(xssMatchSets);
        }

        @Override
        public ListXssMatchSetsResponse build() {
            return new ListXssMatchSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListXssMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder xssMatchSets(Collection<XssMatchSetSummary> var1);

        public Builder xssMatchSets(XssMatchSetSummary ... var1);

        public Builder xssMatchSets(Consumer<XssMatchSetSummary.Builder> ... var1);
    }
}

