/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies custom configurations for the associations between the web ACL and protected resources.
 * </p>
 * <p>
 * Use this to customize the maximum size of the request body that your protected CloudFront distributions forward to
 * WAF for inspection. The default is 16 KB (16,384 kilobytes).
 * </p>
 * <note>
 * <p>
 * You are charged additional fees when your protected resources forward body sizes that are larger than the default.
 * For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationConfig.Builder, AssociationConfig> {
    private static final SdkField<Map<String, RequestBodyAssociatedResourceTypeConfig>> REQUEST_BODY_FIELD = SdkField
            .<Map<String, RequestBodyAssociatedResourceTypeConfig>> builder(MarshallingType.MAP)
            .memberName("RequestBody")
            .getter(getter(AssociationConfig::requestBodyAsStrings))
            .setter(setter(Builder::requestBodyWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBody").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RequestBodyAssociatedResourceTypeConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestBodyAssociatedResourceTypeConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_BODY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody;

    private AssociationConfig(BuilderImpl builder) {
        this.requestBody = builder.requestBody;
    }

    /**
     * <p>
     * Customizes the maximum size of the request body that your protected CloudFront distributions forward to WAF for
     * inspection. The default size is 16 KB (16,384 kilobytes).
     * </p>
     * <note>
     * <p>
     * You are charged additional fees when your protected resources forward body sizes that are larger than the
     * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestBody} method.
     * </p>
     * 
     * @return Customizes the maximum size of the request body that your protected CloudFront distributions forward to
     *         WAF for inspection. The default size is 16 KB (16,384 kilobytes). </p> <note>
     *         <p>
     *         You are charged additional fees when your protected resources forward body sizes that are larger than the
     *         default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     *         </p>
     */
    public final Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> requestBody() {
        return RequestBodyCopier.copyStringToEnum(requestBody);
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestBody property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestBody() {
        return requestBody != null && !(requestBody instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Customizes the maximum size of the request body that your protected CloudFront distributions forward to WAF for
     * inspection. The default size is 16 KB (16,384 kilobytes).
     * </p>
     * <note>
     * <p>
     * You are charged additional fees when your protected resources forward body sizes that are larger than the
     * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestBody} method.
     * </p>
     * 
     * @return Customizes the maximum size of the request body that your protected CloudFront distributions forward to
     *         WAF for inspection. The default size is 16 KB (16,384 kilobytes). </p> <note>
     *         <p>
     *         You are charged additional fees when your protected resources forward body sizes that are larger than the
     *         default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
     *         </p>
     */
    public final Map<String, RequestBodyAssociatedResourceTypeConfig> requestBodyAsStrings() {
        return requestBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestBody() ? requestBodyAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationConfig)) {
            return false;
        }
        AssociationConfig other = (AssociationConfig) obj;
        return hasRequestBody() == other.hasRequestBody() && Objects.equals(requestBodyAsStrings(), other.requestBodyAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationConfig").add("RequestBody", hasRequestBody() ? requestBodyAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestBody":
            return Optional.ofNullable(clazz.cast(requestBodyAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationConfig, T> g) {
        return obj -> g.apply((AssociationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationConfig> {
        /**
         * <p>
         * Customizes the maximum size of the request body that your protected CloudFront distributions forward to WAF
         * for inspection. The default size is 16 KB (16,384 kilobytes).
         * </p>
         * <note>
         * <p>
         * You are charged additional fees when your protected resources forward body sizes that are larger than the
         * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         * </p>
         * </note>
         * 
         * @param requestBody
         *        Customizes the maximum size of the request body that your protected CloudFront distributions forward
         *        to WAF for inspection. The default size is 16 KB (16,384 kilobytes). </p> <note>
         *        <p>
         *        You are charged additional fees when your protected resources forward body sizes that are larger than
         *        the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBodyWithStrings(Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody);

        /**
         * <p>
         * Customizes the maximum size of the request body that your protected CloudFront distributions forward to WAF
         * for inspection. The default size is 16 KB (16,384 kilobytes).
         * </p>
         * <note>
         * <p>
         * You are charged additional fees when your protected resources forward body sizes that are larger than the
         * default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         * </p>
         * </note>
         * 
         * @param requestBody
         *        Customizes the maximum size of the request body that your protected CloudFront distributions forward
         *        to WAF for inspection. The default size is 16 KB (16,384 kilobytes). </p> <note>
         *        <p>
         *        You are charged additional fees when your protected resources forward body sizes that are larger than
         *        the default. For more information, see <a href="http://aws.amazon.com/waf/pricing/">WAF Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBody(Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> requestBody);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationConfig model) {
            requestBodyWithStrings(model.requestBody);
        }

        public final Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> getRequestBody() {
            Map<String, RequestBodyAssociatedResourceTypeConfig.Builder> result = RequestBodyCopier
                    .copyToBuilder(this.requestBody);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRequestBody(Map<String, RequestBodyAssociatedResourceTypeConfig.BuilderImpl> requestBody) {
            this.requestBody = RequestBodyCopier.copyFromBuilder(requestBody);
        }

        @Override
        public final Builder requestBodyWithStrings(Map<String, RequestBodyAssociatedResourceTypeConfig> requestBody) {
            this.requestBody = RequestBodyCopier.copy(requestBody);
            return this;
        }

        @Override
        public final Builder requestBody(Map<AssociatedResourceType, RequestBodyAssociatedResourceTypeConfig> requestBody) {
            this.requestBody = RequestBodyCopier.copyEnumToString(requestBody);
            return this;
        }

        @Override
        public AssociationConfig build() {
            return new AssociationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
