/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of the response from <a>GetSampledRequests</a>. This is a complex type that appears as <code>Request</code> in
 * the response syntax. <code>HTTPRequest</code> contains information about one of the web requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HTTPRequest implements SdkPojo, Serializable, ToCopyableBuilder<HTTPRequest.Builder, HTTPRequest> {
    private static final SdkField<String> CLIENT_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientIP").getter(getter(HTTPRequest::clientIP)).setter(setter(Builder::clientIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIP").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(HTTPRequest::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URI")
            .getter(getter(HTTPRequest::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URI").build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Method")
            .getter(getter(HTTPRequest::method)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()).build();

    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HTTPVersion").getter(getter(HTTPRequest::httpVersion)).setter(setter(Builder::httpVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPVersion").build()).build();

    private static final SdkField<List<HTTPHeader>> HEADERS_FIELD = SdkField
            .<List<HTTPHeader>> builder(MarshallingType.LIST)
            .memberName("Headers")
            .getter(getter(HTTPRequest::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HTTPHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HTTPHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_IP_FIELD,
            COUNTRY_FIELD, URI_FIELD, METHOD_FIELD, HTTP_VERSION_FIELD, HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientIP;

    private final String country;

    private final String uri;

    private final String method;

    private final String httpVersion;

    private final List<HTTPHeader> headers;

    private HTTPRequest(BuilderImpl builder) {
        this.clientIP = builder.clientIP;
        this.country = builder.country;
        this.uri = builder.uri;
        this.method = builder.method;
        this.httpVersion = builder.httpVersion;
        this.headers = builder.headers;
    }

    /**
     * <p>
     * The IP address that the request originated from. If the web ACL is associated with a CloudFront distribution,
     * this is the value of one of the following fields in CloudFront access logs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request
     * </p>
     * </li>
     * </ul>
     * 
     * @return The IP address that the request originated from. If the web ACL is associated with a CloudFront
     *         distribution, this is the value of one of the following fields in CloudFront access logs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request
     *         </p>
     *         </li>
     */
    public final String clientIP() {
        return clientIP;
    }

    /**
     * <p>
     * The two-letter country code for the country that the request originated from. For a current list of country
     * codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.
     * </p>
     * 
     * @return The two-letter country code for the country that the request originated from. For a current list of
     *         country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
     *         3166-1 alpha-2</a>.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The URI path of the request, which identifies the resource, for example, <code>/images/daily-ad.jpg</code>.
     * </p>
     * 
     * @return The URI path of the request, which identifies the resource, for example,
     *         <code>/images/daily-ad.jpg</code>.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The HTTP method specified in the sampled web request.
     * </p>
     * 
     * @return The HTTP method specified in the sampled web request.
     */
    public final String method() {
        return method;
    }

    /**
     * <p>
     * The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.
     * </p>
     * 
     * @return The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.
     */
    public final String httpVersion() {
        return httpVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains the name and value for each header in the sampled web request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return A complex type that contains the name and value for each header in the sampled web request.
     */
    public final List<HTTPHeader> headers() {
        return headers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientIP());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(method());
        hashCode = 31 * hashCode + Objects.hashCode(httpVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTTPRequest)) {
            return false;
        }
        HTTPRequest other = (HTTPRequest) obj;
        return Objects.equals(clientIP(), other.clientIP()) && Objects.equals(country(), other.country())
                && Objects.equals(uri(), other.uri()) && Objects.equals(method(), other.method())
                && Objects.equals(httpVersion(), other.httpVersion()) && hasHeaders() == other.hasHeaders()
                && Objects.equals(headers(), other.headers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HTTPRequest").add("ClientIP", clientIP()).add("Country", country()).add("URI", uri())
                .add("Method", method()).add("HTTPVersion", httpVersion()).add("Headers", hasHeaders() ? headers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientIP":
            return Optional.ofNullable(clazz.cast(clientIP()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "URI":
            return Optional.ofNullable(clazz.cast(uri()));
        case "Method":
            return Optional.ofNullable(clazz.cast(method()));
        case "HTTPVersion":
            return Optional.ofNullable(clazz.cast(httpVersion()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HTTPRequest, T> g) {
        return obj -> g.apply((HTTPRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HTTPRequest> {
        /**
         * <p>
         * The IP address that the request originated from. If the web ACL is associated with a CloudFront distribution,
         * this is the value of one of the following fields in CloudFront access logs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request
         * </p>
         * </li>
         * </ul>
         * 
         * @param clientIP
         *        The IP address that the request originated from. If the web ACL is associated with a CloudFront
         *        distribution, this is the value of one of the following fields in CloudFront access logs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the
         *        request
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIP(String clientIP);

        /**
         * <p>
         * The two-letter country code for the country that the request originated from. For a current list of country
         * codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1
         * alpha-2</a>.
         * </p>
         * 
         * @param country
         *        The two-letter country code for the country that the request originated from. For a current list of
         *        country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
         *        3166-1 alpha-2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The URI path of the request, which identifies the resource, for example, <code>/images/daily-ad.jpg</code>.
         * </p>
         * 
         * @param uri
         *        The URI path of the request, which identifies the resource, for example,
         *        <code>/images/daily-ad.jpg</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The HTTP method specified in the sampled web request.
         * </p>
         * 
         * @param method
         *        The HTTP method specified in the sampled web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(String method);

        /**
         * <p>
         * The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.
         * </p>
         * 
         * @param httpVersion
         *        The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpVersion(String httpVersion);

        /**
         * <p>
         * A complex type that contains the name and value for each header in the sampled web request.
         * </p>
         * 
         * @param headers
         *        A complex type that contains the name and value for each header in the sampled web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<HTTPHeader> headers);

        /**
         * <p>
         * A complex type that contains the name and value for each header in the sampled web request.
         * </p>
         * 
         * @param headers
         *        A complex type that contains the name and value for each header in the sampled web request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(HTTPHeader... headers);

        /**
         * <p>
         * A complex type that contains the name and value for each header in the sampled web request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #headers(List<HTTPHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<HTTPHeader>)
         */
        Builder headers(Consumer<HTTPHeader.Builder>... headers);
    }

    static final class BuilderImpl implements Builder {
        private String clientIP;

        private String country;

        private String uri;

        private String method;

        private String httpVersion;

        private List<HTTPHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HTTPRequest model) {
            clientIP(model.clientIP);
            country(model.country);
            uri(model.uri);
            method(model.method);
            httpVersion(model.httpVersion);
            headers(model.headers);
        }

        public final String getClientIP() {
            return clientIP;
        }

        public final void setClientIP(String clientIP) {
            this.clientIP = clientIP;
        }

        @Override
        public final Builder clientIP(String clientIP) {
            this.clientIP = clientIP;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final String getHttpVersion() {
            return httpVersion;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public final List<HTTPHeader.Builder> getHeaders() {
            List<HTTPHeader.Builder> result = HTTPHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<HTTPHeader.BuilderImpl> headers) {
            this.headers = HTTPHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<HTTPHeader> headers) {
            this.headers = HTTPHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HTTPHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HTTPHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> HTTPHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HTTPRequest build() {
            return new HTTPRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
