/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of IP addresses that are currently blocked for a <a>RateBasedStatement</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RateBasedStatementManagedKeysIPSet implements SdkPojo, Serializable,
        ToCopyableBuilder<RateBasedStatementManagedKeysIPSet.Builder, RateBasedStatementManagedKeysIPSet> {
    private static final SdkField<String> IP_ADDRESS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPAddressVersion").getter(getter(RateBasedStatementManagedKeysIPSet::ipAddressVersionAsString))
            .setter(setter(Builder::ipAddressVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressVersion").build()).build();

    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Addresses")
            .getter(getter(RateBasedStatementManagedKeysIPSet::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_VERSION_FIELD,
            ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddressVersion;

    private final List<String> addresses;

    private RateBasedStatementManagedKeysIPSet(BuilderImpl builder) {
        this.ipAddressVersion = builder.ipAddressVersion;
        this.addresses = builder.addresses;
    }

    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressVersion}
     * will return {@link IPAddressVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipAddressVersionAsString}.
     * </p>
     * 
     * @return The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * @see IPAddressVersion
     */
    public final IPAddressVersion ipAddressVersion() {
        return IPAddressVersion.fromValue(ipAddressVersion);
    }

    /**
     * <p>
     * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressVersion}
     * will return {@link IPAddressVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipAddressVersionAsString}.
     * </p>
     * 
     * @return The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
     * @see IPAddressVersion
     */
    public final String ipAddressVersionAsString() {
        return ipAddressVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Addresses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses that are currently blocked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddresses} method.
     * </p>
     * 
     * @return The IP addresses that are currently blocked.
     */
    public final List<String> addresses() {
        return addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddresses() ? addresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatementManagedKeysIPSet)) {
            return false;
        }
        RateBasedStatementManagedKeysIPSet other = (RateBasedStatementManagedKeysIPSet) obj;
        return Objects.equals(ipAddressVersionAsString(), other.ipAddressVersionAsString())
                && hasAddresses() == other.hasAddresses() && Objects.equals(addresses(), other.addresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RateBasedStatementManagedKeysIPSet").add("IPAddressVersion", ipAddressVersionAsString())
                .add("Addresses", hasAddresses() ? addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPAddressVersion":
            return Optional.ofNullable(clazz.cast(ipAddressVersionAsString()));
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RateBasedStatementManagedKeysIPSet, T> g) {
        return obj -> g.apply((RateBasedStatementManagedKeysIPSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RateBasedStatementManagedKeysIPSet> {
        /**
         * <p>
         * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
         * </p>
         * 
         * @param ipAddressVersion
         *        The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
         * @see IPAddressVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressVersion
         */
        Builder ipAddressVersion(String ipAddressVersion);

        /**
         * <p>
         * The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
         * </p>
         * 
         * @param ipAddressVersion
         *        The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>.
         * @see IPAddressVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressVersion
         */
        Builder ipAddressVersion(IPAddressVersion ipAddressVersion);

        /**
         * <p>
         * The IP addresses that are currently blocked.
         * </p>
         * 
         * @param addresses
         *        The IP addresses that are currently blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<String> addresses);

        /**
         * <p>
         * The IP addresses that are currently blocked.
         * </p>
         * 
         * @param addresses
         *        The IP addresses that are currently blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(String... addresses);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddressVersion;

        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedStatementManagedKeysIPSet model) {
            ipAddressVersion(model.ipAddressVersion);
            addresses(model.addresses);
        }

        public final String getIpAddressVersion() {
            return ipAddressVersion;
        }

        public final void setIpAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
        }

        @Override
        public final Builder ipAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
            return this;
        }

        @Override
        public final Builder ipAddressVersion(IPAddressVersion ipAddressVersion) {
            this.ipAddressVersion(ipAddressVersion == null ? null : ipAddressVersion.toString());
            return this;
        }

        public final Collection<String> getAddresses() {
            if (addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return addresses;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        public RateBasedStatementManagedKeysIPSet build() {
            return new RateBasedStatementManagedKeysIPSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
