/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.Activity;
import software.amazon.awssdk.services.workdocs.model.UserActivitiesCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivitiesResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeActivitiesResponse> {
    private static final SdkField<List<Activity>> USER_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserActivities").getter(DescribeActivitiesResponse.getter(DescribeActivitiesResponse::userActivities)).setter(DescribeActivitiesResponse.setter(Builder::userActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Activity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeActivitiesResponse.getter(DescribeActivitiesResponse::marker)).setter(DescribeActivitiesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ACTIVITIES_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeActivitiesResponse.memberNameToFieldInitializer();
    private final List<Activity> userActivities;
    private final String marker;

    private DescribeActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.userActivities = builder.userActivities;
        this.marker = builder.marker;
    }

    public final boolean hasUserActivities() {
        return this.userActivities != null && !(this.userActivities instanceof SdkAutoConstructList);
    }

    public final List<Activity> userActivities() {
        return this.userActivities;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserActivities() ? this.userActivities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesResponse)) {
            return false;
        }
        DescribeActivitiesResponse other = (DescribeActivitiesResponse)((Object)obj);
        return this.hasUserActivities() == other.hasUserActivities() && Objects.equals(this.userActivities(), other.userActivities()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeActivitiesResponse").add("UserActivities", this.hasUserActivities() ? this.userActivities() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserActivities": {
                return Optional.ofNullable(clazz.cast(this.userActivities()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserActivities", USER_ACTIVITIES_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivitiesResponse, T> g) {
        return obj -> g.apply((DescribeActivitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Activity> userActivities = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesResponse model) {
            super(model);
            this.userActivities(model.userActivities);
            this.marker(model.marker);
        }

        public final List<Activity.Builder> getUserActivities() {
            List<Activity.Builder> result = UserActivitiesCopier.copyToBuilder(this.userActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserActivities(Collection<Activity.BuilderImpl> userActivities) {
            this.userActivities = UserActivitiesCopier.copyFromBuilder(userActivities);
        }

        @Override
        public final Builder userActivities(Collection<Activity> userActivities) {
            this.userActivities = UserActivitiesCopier.copy(userActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Activity ... userActivities) {
            this.userActivities(Arrays.asList(userActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Consumer<Activity.Builder> ... userActivities) {
            this.userActivities(Stream.of(userActivities).map(c -> (Activity)((Activity.Builder)Activity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeActivitiesResponse build() {
            return new DescribeActivitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActivitiesResponse> {
        public Builder userActivities(Collection<Activity> var1);

        public Builder userActivities(Activity ... var1);

        public Builder userActivities(Consumer<Activity.Builder> ... var1);

        public Builder marker(String var1);
    }
}

