/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFolderRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, GetFolderRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(GetFolderRequest.getter(GetFolderRequest::authenticationToken)).setter(GetFolderRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FolderId").getter(GetFolderRequest.getter(GetFolderRequest::folderId)).setter(GetFolderRequest.setter(Builder::folderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CUSTOM_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeCustomMetadata").getter(GetFolderRequest.getter(GetFolderRequest::includeCustomMetadata)).setter(GetFolderRequest.setter(Builder::includeCustomMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeCustomMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, FOLDER_ID_FIELD, INCLUDE_CUSTOM_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFolderRequest.memberNameToFieldInitializer();
    private final String authenticationToken;
    private final String folderId;
    private final Boolean includeCustomMetadata;

    private GetFolderRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.includeCustomMetadata = builder.includeCustomMetadata;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String folderId() {
        return this.folderId;
    }

    public final Boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCustomMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderRequest)) {
            return false;
        }
        GetFolderRequest other = (GetFolderRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.includeCustomMetadata(), other.includeCustomMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetFolderRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("FolderId", (Object)this.folderId()).add("IncludeCustomMetadata", (Object)this.includeCustomMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.ofNullable(clazz.cast(this.folderId()));
            }
            case "IncludeCustomMetadata": {
                return Optional.ofNullable(clazz.cast(this.includeCustomMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("FolderId", FOLDER_ID_FIELD);
        map.put("includeCustomMetadata", INCLUDE_CUSTOM_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFolderRequest, T> g) {
        return obj -> g.apply((GetFolderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private Boolean includeCustomMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.includeCustomMetadata(model.includeCustomMetadata);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Boolean getIncludeCustomMetadata() {
            return this.includeCustomMetadata;
        }

        public final void setIncludeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
        }

        @Override
        public final Builder includeCustomMetadata(Boolean includeCustomMetadata) {
            this.includeCustomMetadata = includeCustomMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFolderRequest build() {
            return new GetFolderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFolderRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder includeCustomMetadata(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

