/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserType {
    USER("USER"),
    ADMIN("ADMIN"),
    POWERUSER("POWERUSER"),
    MINIMALUSER("MINIMALUSER"),
    WORKSPACESUSER("WORKSPACESUSER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserType> VALUE_MAP;
    private final String value;

    private UserType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserType> knownValues() {
        EnumSet<UserType> knownValues = EnumSet.allOf(UserType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserType.class, UserType::toString);
    }
}

