/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesPublisher;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesPublisher;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesPublisher;
import software.amazon.awssdk.services.workspaces.transform.AssociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AuthorizeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountModificationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceBundlesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ListAvailableManagementCidrRangesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspacePropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceStateRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebootWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebuildWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RevokeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StartWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StopWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateRulesOfIpGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultWorkSpacesAsyncClient
implements WorkSpacesAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkSpacesAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkSpacesAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "workspaces";
    }

    @Override
    public CompletableFuture<AssociateIpGroupsResponse> associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateIpGroupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssociateIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateIpGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeIpRulesResponse> authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AuthorizeIpRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AuthorizeIpRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeIpRulesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateIpGroupResponse> createIpGroup(CreateIpGroupRequest createIpGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIpGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIpGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWorkspacesResponse> createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIpGroupResponse> deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIpGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIpGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWorkspaceImageResponse> deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkspaceImageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkspaceImageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountResponse> describeAccount(DescribeAccountRequest describeAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountModificationsResponse> describeAccountModifications(DescribeAccountModificationsRequest describeAccountModificationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountModificationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAccountModificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountModificationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClientPropertiesResponse> describeClientProperties(DescribeClientPropertiesRequest describeClientPropertiesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClientPropertiesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeClientPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClientPropertiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIpGroupsResponse> describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIpGroupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIpGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkspaceBundlesResponse> describeWorkspaceBundles(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceBundlesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeWorkspaceBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceBundlesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeWorkspaceBundlesPublisher describeWorkspaceBundlesPaginator(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        return new DescribeWorkspaceBundlesPublisher(this, this.applyPaginatorUserAgent(describeWorkspaceBundlesRequest));
    }

    @Override
    public CompletableFuture<DescribeWorkspaceDirectoriesResponse> describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceDirectoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeWorkspaceDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceDirectoriesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeWorkspaceDirectoriesPublisher describeWorkspaceDirectoriesPaginator(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        return new DescribeWorkspaceDirectoriesPublisher(this, this.applyPaginatorUserAgent(describeWorkspaceDirectoriesRequest));
    }

    @Override
    public CompletableFuture<DescribeWorkspaceImagesResponse> describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspaceImagesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeWorkspaceImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspaceImagesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkspacesResponse> describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkspacesConnectionStatusResponse> describeWorkspacesConnectionStatus(DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkspacesConnectionStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeWorkspacesConnectionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkspacesConnectionStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeWorkspacesPublisher describeWorkspacesPaginator(DescribeWorkspacesRequest describeWorkspacesRequest) {
        return new DescribeWorkspacesPublisher(this, this.applyPaginatorUserAgent(describeWorkspacesRequest));
    }

    @Override
    public CompletableFuture<DisassociateIpGroupsResponse> disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateIpGroupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisassociateIpGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateIpGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportWorkspaceImageResponse> importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportWorkspaceImageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ImportWorkspaceImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importWorkspaceImageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAvailableManagementCidrRangesResponse> listAvailableManagementCidrRanges(ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAvailableManagementCidrRangesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListAvailableManagementCidrRangesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableManagementCidrRangesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyAccountResponse> modifyAccount(ModifyAccountRequest modifyAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyAccountResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ModifyAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyAccountRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClientPropertiesResponse> modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyClientPropertiesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ModifyClientPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyClientPropertiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyWorkspacePropertiesResponse> modifyWorkspaceProperties(ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspacePropertiesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ModifyWorkspacePropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspacePropertiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyWorkspaceStateResponse> modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyWorkspaceStateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ModifyWorkspaceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyWorkspaceStateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootWorkspacesResponse> rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RebootWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebuildWorkspacesResponse> rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebuildWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RebuildWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebuildWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeIpRulesResponse> revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeIpRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RevokeIpRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeIpRulesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartWorkspacesResponse> startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopWorkspacesResponse> stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StopWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TerminateWorkspacesResponse> terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateWorkspacesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new TerminateWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateWorkspacesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRulesOfIpGroupResponse> updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRulesOfIpGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateRulesOfIpGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRulesOfIpGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkSpacesException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException").exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").exceptionBuilderSupplier(OperationNotSupportedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").exceptionBuilderSupplier(ResourceAssociatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").exceptionBuilderSupplier(InvalidResourceStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").exceptionBuilderSupplier(InvalidParameterValuesException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationInProgressException").exceptionBuilderSupplier(OperationInProgressException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").exceptionBuilderSupplier(ResourceCreationFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
    }

    private <T extends WorkSpacesRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.1.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WorkSpacesRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

