/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.ClientProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientPropertiesResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientPropertiesResult> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientPropertiesResult.getter(ClientPropertiesResult::resourceId)).setter(ClientPropertiesResult.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<ClientProperties> CLIENT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClientPropertiesResult.getter(ClientPropertiesResult::clientProperties)).setter(ClientPropertiesResult.setter(Builder::clientProperties)).constructor(ClientProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, CLIENT_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final ClientProperties clientProperties;

    private ClientPropertiesResult(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.clientProperties = builder.clientProperties;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ClientProperties clientProperties() {
        return this.clientProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientPropertiesResult)) {
            return false;
        }
        ClientPropertiesResult other = (ClientPropertiesResult)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.clientProperties(), other.clientProperties());
    }

    public String toString() {
        return ToString.builder((String)"ClientPropertiesResult").add("ResourceId", (Object)this.resourceId()).add("ClientProperties", (Object)this.clientProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ClientProperties": {
                return Optional.ofNullable(clazz.cast(this.clientProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientPropertiesResult, T> g) {
        return obj -> g.apply((ClientPropertiesResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private ClientProperties clientProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientPropertiesResult model) {
            this.resourceId(model.resourceId);
            this.clientProperties(model.clientProperties);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final ClientProperties.Builder getClientProperties() {
            return this.clientProperties != null ? this.clientProperties.toBuilder() : null;
        }

        @Override
        public final Builder clientProperties(ClientProperties clientProperties) {
            this.clientProperties = clientProperties;
            return this;
        }

        public final void setClientProperties(ClientProperties.BuilderImpl clientProperties) {
            this.clientProperties = clientProperties != null ? clientProperties.build() : null;
        }

        public ClientPropertiesResult build() {
            return new ClientPropertiesResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientPropertiesResult> {
        public Builder resourceId(String var1);

        public Builder clientProperties(ClientProperties var1);

        default public Builder clientProperties(Consumer<ClientProperties.Builder> clientProperties) {
            return this.clientProperties((ClientProperties)((ClientProperties.Builder)ClientProperties.builder().applyMutation(clientProperties)).build());
        }
    }
}

