/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.Workspace;
import software.amazon.awssdk.services.workspaces.model.WorkspaceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspacesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, CreateWorkspacesResponse> {
    private static final SdkField<List<FailedCreateWorkspaceRequest>> FAILED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateWorkspacesResponse.getter(CreateWorkspacesResponse::failedRequests)).setter(CreateWorkspacesResponse.setter(Builder::failedRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedCreateWorkspaceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Workspace>> PENDING_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateWorkspacesResponse.getter(CreateWorkspacesResponse::pendingRequests)).setter(CreateWorkspacesResponse.setter(Builder::pendingRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workspace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_REQUESTS_FIELD, PENDING_REQUESTS_FIELD));
    private final List<FailedCreateWorkspaceRequest> failedRequests;
    private final List<Workspace> pendingRequests;

    private CreateWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.failedRequests = builder.failedRequests;
        this.pendingRequests = builder.pendingRequests;
    }

    public List<FailedCreateWorkspaceRequest> failedRequests() {
        return this.failedRequests;
    }

    public List<Workspace> pendingRequests() {
        return this.pendingRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRequests());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesResponse)) {
            return false;
        }
        CreateWorkspacesResponse other = (CreateWorkspacesResponse)((Object)obj);
        return Objects.equals(this.failedRequests(), other.failedRequests()) && Objects.equals(this.pendingRequests(), other.pendingRequests());
    }

    public String toString() {
        return ToString.builder((String)"CreateWorkspacesResponse").add("FailedRequests", this.failedRequests()).add("PendingRequests", this.pendingRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedRequests": {
                return Optional.ofNullable(clazz.cast(this.failedRequests()));
            }
            case "PendingRequests": {
                return Optional.ofNullable(clazz.cast(this.pendingRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspacesResponse, T> g) {
        return obj -> g.apply((CreateWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<FailedCreateWorkspaceRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();
        private List<Workspace> pendingRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspacesResponse model) {
            super(model);
            this.failedRequests(model.failedRequests);
            this.pendingRequests(model.pendingRequests);
        }

        public final Collection<FailedCreateWorkspaceRequest.Builder> getFailedRequests() {
            return this.failedRequests != null ? (Collection)this.failedRequests.stream().map(FailedCreateWorkspaceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedRequests(Collection<FailedCreateWorkspaceRequest> failedRequests) {
            this.failedRequests = FailedCreateWorkspaceRequestsCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedCreateWorkspaceRequest ... failedRequests) {
            this.failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedCreateWorkspaceRequest.Builder> ... failedRequests) {
            this.failedRequests(Stream.of(failedRequests).map(c -> (FailedCreateWorkspaceRequest)((FailedCreateWorkspaceRequest.Builder)FailedCreateWorkspaceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedRequests(Collection<FailedCreateWorkspaceRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedCreateWorkspaceRequestsCopier.copyFromBuilder(failedRequests);
        }

        public final Collection<Workspace.Builder> getPendingRequests() {
            return this.pendingRequests != null ? (Collection)this.pendingRequests.stream().map(Workspace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingRequests(Collection<Workspace> pendingRequests) {
            this.pendingRequests = WorkspaceListCopier.copy(pendingRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(Workspace ... pendingRequests) {
            this.pendingRequests(Arrays.asList(pendingRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(Consumer<Workspace.Builder> ... pendingRequests) {
            this.pendingRequests(Stream.of(pendingRequests).map(c -> (Workspace)((Workspace.Builder)Workspace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingRequests(Collection<Workspace.BuilderImpl> pendingRequests) {
            this.pendingRequests = WorkspaceListCopier.copyFromBuilder(pendingRequests);
        }

        @Override
        public CreateWorkspacesResponse build() {
            return new CreateWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspacesResponse> {
        public Builder failedRequests(Collection<FailedCreateWorkspaceRequest> var1);

        public Builder failedRequests(FailedCreateWorkspaceRequest ... var1);

        public Builder failedRequests(Consumer<FailedCreateWorkspaceRequest.Builder> ... var1);

        public Builder pendingRequests(Collection<Workspace> var1);

        public Builder pendingRequests(Workspace ... var1);

        public Builder pendingRequests(Consumer<Workspace.Builder> ... var1);
    }
}

