/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DirectoryIdListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceDirectoriesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspaceDirectoriesRequest> {
    private static final SdkField<List<String>> DIRECTORY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::directoryIds)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::directoryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspaceDirectoriesRequest.getter(DescribeWorkspaceDirectoriesRequest::nextToken)).setter(DescribeWorkspaceDirectoriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> directoryIds;
    private final String nextToken;

    private DescribeWorkspaceDirectoriesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryIds = builder.directoryIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> directoryIds() {
        return this.directoryIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceDirectoriesRequest)) {
            return false;
        }
        DescribeWorkspaceDirectoriesRequest other = (DescribeWorkspaceDirectoriesRequest)((Object)obj);
        return Objects.equals(this.directoryIds(), other.directoryIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkspaceDirectoriesRequest").add("DirectoryIds", this.directoryIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryIds": {
                return Optional.ofNullable(clazz.cast(this.directoryIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceDirectoriesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceDirectoriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> directoryIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceDirectoriesRequest model) {
            super(model);
            this.directoryIds(model.directoryIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDirectoryIds() {
            return this.directoryIds;
        }

        @Override
        public final Builder directoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryIds(String ... directoryIds) {
            this.directoryIds(Arrays.asList(directoryIds));
            return this;
        }

        public final void setDirectoryIds(Collection<String> directoryIds) {
            this.directoryIds = DirectoryIdListCopier.copy(directoryIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceDirectoriesRequest build() {
            return new DescribeWorkspaceDirectoriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceDirectoriesRequest> {
        public Builder directoryIds(Collection<String> var1);

        public Builder directoryIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

