/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspacesRequest> {
    private static final SdkField<List<String>> WORKSPACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::workspaceIds)).setter(DescribeWorkspacesRequest.setter(Builder::workspaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::directoryId)).setter(DescribeWorkspacesRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::userName)).setter(DescribeWorkspacesRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::bundleId)).setter(DescribeWorkspacesRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::limit)).setter(DescribeWorkspacesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspacesRequest.getter(DescribeWorkspacesRequest::nextToken)).setter(DescribeWorkspacesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_IDS_FIELD, DIRECTORY_ID_FIELD, USER_NAME_FIELD, BUNDLE_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> workspaceIds;
    private final String directoryId;
    private final String userName;
    private final String bundleId;
    private final Integer limit;
    private final String nextToken;

    private DescribeWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceIds = builder.workspaceIds;
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.bundleId = builder.bundleId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public List<String> workspaceIds() {
        return this.workspaceIds;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String userName() {
        return this.userName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesRequest)) {
            return false;
        }
        DescribeWorkspacesRequest other = (DescribeWorkspacesRequest)((Object)obj);
        return Objects.equals(this.workspaceIds(), other.workspaceIds()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkspacesRequest").add("WorkspaceIds", this.workspaceIds()).add("DirectoryId", (Object)this.directoryId()).add("UserName", (Object)this.userName()).add("BundleId", (Object)this.bundleId()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceIds": {
                return Optional.ofNullable(clazz.cast(this.workspaceIds()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> workspaceIds = DefaultSdkAutoConstructList.getInstance();
        private String directoryId;
        private String userName;
        private String bundleId;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesRequest model) {
            super(model);
            this.workspaceIds(model.workspaceIds);
            this.directoryId(model.directoryId);
            this.userName(model.userName);
            this.bundleId(model.bundleId);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getWorkspaceIds() {
            return this.workspaceIds;
        }

        @Override
        public final Builder workspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceIds(String ... workspaceIds) {
            this.workspaceIds(Arrays.asList(workspaceIds));
            return this;
        }

        public final void setWorkspaceIds(Collection<String> workspaceIds) {
            this.workspaceIds = WorkspaceIdListCopier.copy(workspaceIds);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesRequest build() {
            return new DescribeWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesRequest> {
        public Builder workspaceIds(Collection<String> var1);

        public Builder workspaceIds(String ... var1);

        public Builder directoryId(String var1);

        public Builder userName(String var1);

        public Builder bundleId(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

