/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportWorkspaceImageRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ImportWorkspaceImageRequest> {
    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::ec2ImageId)).setter(ImportWorkspaceImageRequest.setter(Builder::ec2ImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2ImageId").build()}).build();
    private static final SdkField<String> INGESTION_PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::ingestionProcessAsString)).setter(ImportWorkspaceImageRequest.setter(Builder::ingestionProcess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionProcess").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::imageName)).setter(ImportWorkspaceImageRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportWorkspaceImageRequest.getter(ImportWorkspaceImageRequest::imageDescription)).setter(ImportWorkspaceImageRequest.setter(Builder::imageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_IMAGE_ID_FIELD, INGESTION_PROCESS_FIELD, IMAGE_NAME_FIELD, IMAGE_DESCRIPTION_FIELD));
    private final String ec2ImageId;
    private final String ingestionProcess;
    private final String imageName;
    private final String imageDescription;

    private ImportWorkspaceImageRequest(BuilderImpl builder) {
        super(builder);
        this.ec2ImageId = builder.ec2ImageId;
        this.ingestionProcess = builder.ingestionProcess;
        this.imageName = builder.imageName;
        this.imageDescription = builder.imageDescription;
    }

    public String ec2ImageId() {
        return this.ec2ImageId;
    }

    public WorkspaceImageIngestionProcess ingestionProcess() {
        return WorkspaceImageIngestionProcess.fromValue(this.ingestionProcess);
    }

    public String ingestionProcessAsString() {
        return this.ingestionProcess;
    }

    public String imageName() {
        return this.imageName;
    }

    public String imageDescription() {
        return this.imageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionProcessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportWorkspaceImageRequest)) {
            return false;
        }
        ImportWorkspaceImageRequest other = (ImportWorkspaceImageRequest)((Object)obj);
        return Objects.equals(this.ec2ImageId(), other.ec2ImageId()) && Objects.equals(this.ingestionProcessAsString(), other.ingestionProcessAsString()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageDescription(), other.imageDescription());
    }

    public String toString() {
        return ToString.builder((String)"ImportWorkspaceImageRequest").add("Ec2ImageId", (Object)this.ec2ImageId()).add("IngestionProcess", (Object)this.ingestionProcessAsString()).add("ImageName", (Object)this.imageName()).add("ImageDescription", (Object)this.imageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2ImageId": {
                return Optional.ofNullable(clazz.cast(this.ec2ImageId()));
            }
            case "IngestionProcess": {
                return Optional.ofNullable(clazz.cast(this.ingestionProcessAsString()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageDescription": {
                return Optional.ofNullable(clazz.cast(this.imageDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportWorkspaceImageRequest, T> g) {
        return obj -> g.apply((ImportWorkspaceImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String ec2ImageId;
        private String ingestionProcess;
        private String imageName;
        private String imageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportWorkspaceImageRequest model) {
            super(model);
            this.ec2ImageId(model.ec2ImageId);
            this.ingestionProcess(model.ingestionProcess);
            this.imageName(model.imageName);
            this.imageDescription(model.imageDescription);
        }

        public final String getEc2ImageId() {
            return this.ec2ImageId;
        }

        @Override
        public final Builder ec2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
            return this;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
        }

        public final String getIngestionProcess() {
            return this.ingestionProcess;
        }

        @Override
        public final Builder ingestionProcess(String ingestionProcess) {
            this.ingestionProcess = ingestionProcess;
            return this;
        }

        @Override
        public final Builder ingestionProcess(WorkspaceImageIngestionProcess ingestionProcess) {
            this.ingestionProcess(ingestionProcess.toString());
            return this;
        }

        public final void setIngestionProcess(String ingestionProcess) {
            this.ingestionProcess = ingestionProcess;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageDescription() {
            return this.imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportWorkspaceImageRequest build() {
            return new ImportWorkspaceImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportWorkspaceImageRequest> {
        public Builder ec2ImageId(String var1);

        public Builder ingestionProcess(String var1);

        public Builder ingestionProcess(WorkspaceImageIngestionProcess var1);

        public Builder imageName(String var1);

        public Builder imageDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

