/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.RebuildRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebuildWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, RebuildWorkspacesRequest> {
    private static final SdkField<List<RebuildRequest>> REBUILD_WORKSPACE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RebuildWorkspacesRequest.getter(RebuildWorkspacesRequest::rebuildWorkspaceRequests)).setter(RebuildWorkspacesRequest.setter(Builder::rebuildWorkspaceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebuildWorkspaceRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RebuildRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBUILD_WORKSPACE_REQUESTS_FIELD));
    private final List<RebuildRequest> rebuildWorkspaceRequests;

    private RebuildWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.rebuildWorkspaceRequests = builder.rebuildWorkspaceRequests;
    }

    public List<RebuildRequest> rebuildWorkspaceRequests() {
        return this.rebuildWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rebuildWorkspaceRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebuildWorkspacesRequest)) {
            return false;
        }
        RebuildWorkspacesRequest other = (RebuildWorkspacesRequest)((Object)obj);
        return Objects.equals(this.rebuildWorkspaceRequests(), other.rebuildWorkspaceRequests());
    }

    public String toString() {
        return ToString.builder((String)"RebuildWorkspacesRequest").add("RebuildWorkspaceRequests", this.rebuildWorkspaceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RebuildWorkspaceRequests": {
                return Optional.ofNullable(clazz.cast(this.rebuildWorkspaceRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebuildWorkspacesRequest, T> g) {
        return obj -> g.apply((RebuildWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<RebuildRequest> rebuildWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebuildWorkspacesRequest model) {
            super(model);
            this.rebuildWorkspaceRequests(model.rebuildWorkspaceRequests);
        }

        public final Collection<RebuildRequest.Builder> getRebuildWorkspaceRequests() {
            return this.rebuildWorkspaceRequests != null ? (Collection)this.rebuildWorkspaceRequests.stream().map(RebuildRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rebuildWorkspaceRequests(Collection<RebuildRequest> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copy(rebuildWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(RebuildRequest ... rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests(Arrays.asList(rebuildWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder> ... rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests(Stream.of(rebuildWorkspaceRequests).map(c -> (RebuildRequest)((RebuildRequest.Builder)RebuildRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRebuildWorkspaceRequests(Collection<RebuildRequest.BuilderImpl> rebuildWorkspaceRequests) {
            this.rebuildWorkspaceRequests = RebuildWorkspaceRequestsCopier.copyFromBuilder(rebuildWorkspaceRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebuildWorkspacesRequest build() {
            return new RebuildWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebuildWorkspacesRequest> {
        public Builder rebuildWorkspaceRequests(Collection<RebuildRequest> var1);

        public Builder rebuildWorkspaceRequests(RebuildRequest ... var1);

        public Builder rebuildWorkspaceRequests(Consumer<RebuildRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

