/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.StartRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, StartWorkspacesRequest> {
    private static final SdkField<List<StartRequest>> START_WORKSPACE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartWorkspacesRequest.getter(StartWorkspacesRequest::startWorkspaceRequests)).setter(StartWorkspacesRequest.setter(Builder::startWorkspaceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWorkspaceRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_WORKSPACE_REQUESTS_FIELD));
    private final List<StartRequest> startWorkspaceRequests;

    private StartWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.startWorkspaceRequests = builder.startWorkspaceRequests;
    }

    public List<StartRequest> startWorkspaceRequests() {
        return this.startWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startWorkspaceRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkspacesRequest)) {
            return false;
        }
        StartWorkspacesRequest other = (StartWorkspacesRequest)((Object)obj);
        return Objects.equals(this.startWorkspaceRequests(), other.startWorkspaceRequests());
    }

    public String toString() {
        return ToString.builder((String)"StartWorkspacesRequest").add("StartWorkspaceRequests", this.startWorkspaceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartWorkspaceRequests": {
                return Optional.ofNullable(clazz.cast(this.startWorkspaceRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartWorkspacesRequest, T> g) {
        return obj -> g.apply((StartWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<StartRequest> startWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkspacesRequest model) {
            super(model);
            this.startWorkspaceRequests(model.startWorkspaceRequests);
        }

        public final Collection<StartRequest.Builder> getStartWorkspaceRequests() {
            return this.startWorkspaceRequests != null ? (Collection)this.startWorkspaceRequests.stream().map(StartRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startWorkspaceRequests(Collection<StartRequest> startWorkspaceRequests) {
            this.startWorkspaceRequests = StartWorkspaceRequestsCopier.copy(startWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startWorkspaceRequests(StartRequest ... startWorkspaceRequests) {
            this.startWorkspaceRequests(Arrays.asList(startWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startWorkspaceRequests(Consumer<StartRequest.Builder> ... startWorkspaceRequests) {
            this.startWorkspaceRequests(Stream.of(startWorkspaceRequests).map(c -> (StartRequest)((StartRequest.Builder)StartRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStartWorkspaceRequests(Collection<StartRequest.BuilderImpl> startWorkspaceRequests) {
            this.startWorkspaceRequests = StartWorkspaceRequestsCopier.copyFromBuilder(startWorkspaceRequests);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWorkspacesRequest build() {
            return new StartWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWorkspacesRequest> {
        public Builder startWorkspaceRequests(Collection<StartRequest> var1);

        public Builder startWorkspaceRequests(StartRequest ... var1);

        public Builder startWorkspaceRequests(Consumer<StartRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

