/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.FailedStopWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.FailedWorkspaceChangeRequest;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopWorkspacesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, StopWorkspacesResponse> {
    private static final SdkField<List<FailedWorkspaceChangeRequest>> FAILED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StopWorkspacesResponse.getter(StopWorkspacesResponse::failedRequests)).setter(StopWorkspacesResponse.setter(Builder::failedRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedWorkspaceChangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_REQUESTS_FIELD));
    private final List<FailedWorkspaceChangeRequest> failedRequests;

    private StopWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.failedRequests = builder.failedRequests;
    }

    public List<FailedWorkspaceChangeRequest> failedRequests() {
        return this.failedRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopWorkspacesResponse)) {
            return false;
        }
        StopWorkspacesResponse other = (StopWorkspacesResponse)((Object)obj);
        return Objects.equals(this.failedRequests(), other.failedRequests());
    }

    public String toString() {
        return ToString.builder((String)"StopWorkspacesResponse").add("FailedRequests", this.failedRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedRequests": {
                return Optional.ofNullable(clazz.cast(this.failedRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopWorkspacesResponse, T> g) {
        return obj -> g.apply((StopWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<FailedWorkspaceChangeRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopWorkspacesResponse model) {
            super(model);
            this.failedRequests(model.failedRequests);
        }

        public final Collection<FailedWorkspaceChangeRequest.Builder> getFailedRequests() {
            return this.failedRequests != null ? (Collection)this.failedRequests.stream().map(FailedWorkspaceChangeRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedRequests(Collection<FailedWorkspaceChangeRequest> failedRequests) {
            this.failedRequests = FailedStopWorkspaceRequestsCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedWorkspaceChangeRequest ... failedRequests) {
            this.failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedWorkspaceChangeRequest.Builder> ... failedRequests) {
            this.failedRequests(Stream.of(failedRequests).map(c -> (FailedWorkspaceChangeRequest)((FailedWorkspaceChangeRequest.Builder)FailedWorkspaceChangeRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedRequests(Collection<FailedWorkspaceChangeRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedStopWorkspaceRequestsCopier.copyFromBuilder(failedRequests);
        }

        @Override
        public StopWorkspacesResponse build() {
            return new StopWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopWorkspacesResponse> {
        public Builder failedRequests(Collection<FailedWorkspaceChangeRequest> var1);

        public Builder failedRequests(FailedWorkspaceChangeRequest ... var1);

        public Builder failedRequests(Consumer<FailedWorkspaceChangeRequest.Builder> ... var1);
    }
}

