/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ModificationState;
import software.amazon.awssdk.services.workspaces.model.ModificationStateListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkspaceProperties;
import software.amazon.awssdk.services.workspaces.model.WorkspaceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workspace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workspace> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::workspaceId)).setter(Workspace.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::directoryId)).setter(Workspace.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::userName)).setter(Workspace.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::ipAddress)).setter(Workspace.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::stateAsString)).setter(Workspace.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::bundleId)).setter(Workspace.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::subnetId)).setter(Workspace.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::errorMessage)).setter(Workspace.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::errorCode)).setter(Workspace.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::computerName)).setter(Workspace.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Workspace.getter(Workspace::volumeEncryptionKey)).setter(Workspace.setter(Builder::volumeEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build()}).build();
    private static final SdkField<Boolean> USER_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Workspace.getter(Workspace::userVolumeEncryptionEnabled)).setter(Workspace.setter(Builder::userVolumeEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Workspace.getter(Workspace::rootVolumeEncryptionEnabled)).setter(Workspace.setter(Builder::rootVolumeEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeEncryptionEnabled").build()}).build();
    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Workspace.getter(Workspace::workspaceProperties)).setter(Workspace.setter(Builder::workspaceProperties)).constructor(WorkspaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build()}).build();
    private static final SdkField<List<ModificationState>> MODIFICATION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Workspace.getter(Workspace::modificationStates)).setter(Workspace.setter(Builder::modificationStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModificationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, DIRECTORY_ID_FIELD, USER_NAME_FIELD, IP_ADDRESS_FIELD, STATE_FIELD, BUNDLE_ID_FIELD, SUBNET_ID_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, COMPUTER_NAME_FIELD, VOLUME_ENCRYPTION_KEY_FIELD, USER_VOLUME_ENCRYPTION_ENABLED_FIELD, ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD, WORKSPACE_PROPERTIES_FIELD, MODIFICATION_STATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workspaceId;
    private final String directoryId;
    private final String userName;
    private final String ipAddress;
    private final String state;
    private final String bundleId;
    private final String subnetId;
    private final String errorMessage;
    private final String errorCode;
    private final String computerName;
    private final String volumeEncryptionKey;
    private final Boolean userVolumeEncryptionEnabled;
    private final Boolean rootVolumeEncryptionEnabled;
    private final WorkspaceProperties workspaceProperties;
    private final List<ModificationState> modificationStates;

    private Workspace(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.bundleId = builder.bundleId;
        this.subnetId = builder.subnetId;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.computerName = builder.computerName;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.userVolumeEncryptionEnabled = builder.userVolumeEncryptionEnabled;
        this.rootVolumeEncryptionEnabled = builder.rootVolumeEncryptionEnabled;
        this.workspaceProperties = builder.workspaceProperties;
        this.modificationStates = builder.modificationStates;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String userName() {
        return this.userName;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public WorkspaceState state() {
        return WorkspaceState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String computerName() {
        return this.computerName;
    }

    public String volumeEncryptionKey() {
        return this.volumeEncryptionKey;
    }

    public Boolean userVolumeEncryptionEnabled() {
        return this.userVolumeEncryptionEnabled;
    }

    public Boolean rootVolumeEncryptionEnabled() {
        return this.rootVolumeEncryptionEnabled;
    }

    public WorkspaceProperties workspaceProperties() {
        return this.workspaceProperties;
    }

    public List<ModificationState> modificationStates() {
        return this.modificationStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.userVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace)obj;
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.volumeEncryptionKey(), other.volumeEncryptionKey()) && Objects.equals(this.userVolumeEncryptionEnabled(), other.userVolumeEncryptionEnabled()) && Objects.equals(this.rootVolumeEncryptionEnabled(), other.rootVolumeEncryptionEnabled()) && Objects.equals(this.workspaceProperties(), other.workspaceProperties()) && Objects.equals(this.modificationStates(), other.modificationStates());
    }

    public String toString() {
        return ToString.builder((String)"Workspace").add("WorkspaceId", (Object)this.workspaceId()).add("DirectoryId", (Object)this.directoryId()).add("UserName", (Object)this.userName()).add("IpAddress", (Object)this.ipAddress()).add("State", (Object)this.stateAsString()).add("BundleId", (Object)this.bundleId()).add("SubnetId", (Object)this.subnetId()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("ComputerName", (Object)this.computerName()).add("VolumeEncryptionKey", (Object)this.volumeEncryptionKey()).add("UserVolumeEncryptionEnabled", (Object)this.userVolumeEncryptionEnabled()).add("RootVolumeEncryptionEnabled", (Object)this.rootVolumeEncryptionEnabled()).add("WorkspaceProperties", (Object)this.workspaceProperties()).add("ModificationStates", this.modificationStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "VolumeEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKey()));
            }
            case "UserVolumeEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.userVolumeEncryptionEnabled()));
            }
            case "RootVolumeEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeEncryptionEnabled()));
            }
            case "WorkspaceProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceProperties()));
            }
            case "ModificationStates": {
                return Optional.ofNullable(clazz.cast(this.modificationStates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workspace, T> g) {
        return obj -> g.apply((Workspace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workspaceId;
        private String directoryId;
        private String userName;
        private String ipAddress;
        private String state;
        private String bundleId;
        private String subnetId;
        private String errorMessage;
        private String errorCode;
        private String computerName;
        private String volumeEncryptionKey;
        private Boolean userVolumeEncryptionEnabled;
        private Boolean rootVolumeEncryptionEnabled;
        private WorkspaceProperties workspaceProperties;
        private List<ModificationState> modificationStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workspace model) {
            this.workspaceId(model.workspaceId);
            this.directoryId(model.directoryId);
            this.userName(model.userName);
            this.ipAddress(model.ipAddress);
            this.state(model.state);
            this.bundleId(model.bundleId);
            this.subnetId(model.subnetId);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.computerName(model.computerName);
            this.volumeEncryptionKey(model.volumeEncryptionKey);
            this.userVolumeEncryptionEnabled(model.userVolumeEncryptionEnabled);
            this.rootVolumeEncryptionEnabled(model.rootVolumeEncryptionEnabled);
            this.workspaceProperties(model.workspaceProperties);
            this.modificationStates(model.modificationStates);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        public final Boolean getUserVolumeEncryptionEnabled() {
            return this.userVolumeEncryptionEnabled;
        }

        @Override
        public final Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
            return this;
        }

        public final void setUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
        }

        public final Boolean getRootVolumeEncryptionEnabled() {
            return this.rootVolumeEncryptionEnabled;
        }

        @Override
        public final Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
            return this;
        }

        public final void setRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return this.workspaceProperties != null ? this.workspaceProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        public final Collection<ModificationState.Builder> getModificationStates() {
            return this.modificationStates != null ? (Collection)this.modificationStates.stream().map(ModificationState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modificationStates(Collection<ModificationState> modificationStates) {
            this.modificationStates = ModificationStateListCopier.copy(modificationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationStates(ModificationState ... modificationStates) {
            this.modificationStates(Arrays.asList(modificationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationStates(Consumer<ModificationState.Builder> ... modificationStates) {
            this.modificationStates(Stream.of(modificationStates).map(c -> (ModificationState)((ModificationState.Builder)ModificationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModificationStates(Collection<ModificationState.BuilderImpl> modificationStates) {
            this.modificationStates = ModificationStateListCopier.copyFromBuilder(modificationStates);
        }

        public Workspace build() {
            return new Workspace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workspace> {
        public Builder workspaceId(String var1);

        public Builder directoryId(String var1);

        public Builder userName(String var1);

        public Builder ipAddress(String var1);

        public Builder state(String var1);

        public Builder state(WorkspaceState var1);

        public Builder bundleId(String var1);

        public Builder subnetId(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder computerName(String var1);

        public Builder volumeEncryptionKey(String var1);

        public Builder userVolumeEncryptionEnabled(Boolean var1);

        public Builder rootVolumeEncryptionEnabled(Boolean var1);

        public Builder workspaceProperties(WorkspaceProperties var1);

        default public Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return this.workspaceProperties((WorkspaceProperties)((WorkspaceProperties.Builder)WorkspaceProperties.builder().applyMutation(workspaceProperties)).build());
        }

        public Builder modificationStates(Collection<ModificationState> var1);

        public Builder modificationStates(ModificationState ... var1);

        public Builder modificationStates(Consumer<ModificationState.Builder> ... var1);
    }
}

