/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkspaceProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceRequest.getter(WorkspaceRequest::directoryId)).setter(WorkspaceRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceRequest.getter(WorkspaceRequest::userName)).setter(WorkspaceRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceRequest.getter(WorkspaceRequest::bundleId)).setter(WorkspaceRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceRequest.getter(WorkspaceRequest::volumeEncryptionKey)).setter(WorkspaceRequest.setter(Builder::volumeEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build()}).build();
    private static final SdkField<Boolean> USER_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkspaceRequest.getter(WorkspaceRequest::userVolumeEncryptionEnabled)).setter(WorkspaceRequest.setter(Builder::userVolumeEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkspaceRequest.getter(WorkspaceRequest::rootVolumeEncryptionEnabled)).setter(WorkspaceRequest.setter(Builder::rootVolumeEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeEncryptionEnabled").build()}).build();
    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkspaceRequest.getter(WorkspaceRequest::workspaceProperties)).setter(WorkspaceRequest.setter(Builder::workspaceProperties)).constructor(WorkspaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(WorkspaceRequest.getter(WorkspaceRequest::tags)).setter(WorkspaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, USER_NAME_FIELD, BUNDLE_ID_FIELD, VOLUME_ENCRYPTION_KEY_FIELD, USER_VOLUME_ENCRYPTION_ENABLED_FIELD, ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD, WORKSPACE_PROPERTIES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String userName;
    private final String bundleId;
    private final String volumeEncryptionKey;
    private final Boolean userVolumeEncryptionEnabled;
    private final Boolean rootVolumeEncryptionEnabled;
    private final WorkspaceProperties workspaceProperties;
    private final List<Tag> tags;

    private WorkspaceRequest(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.bundleId = builder.bundleId;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.userVolumeEncryptionEnabled = builder.userVolumeEncryptionEnabled;
        this.rootVolumeEncryptionEnabled = builder.rootVolumeEncryptionEnabled;
        this.workspaceProperties = builder.workspaceProperties;
        this.tags = builder.tags;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String userName() {
        return this.userName;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String volumeEncryptionKey() {
        return this.volumeEncryptionKey;
    }

    public Boolean userVolumeEncryptionEnabled() {
        return this.userVolumeEncryptionEnabled;
    }

    public Boolean rootVolumeEncryptionEnabled() {
        return this.rootVolumeEncryptionEnabled;
    }

    public WorkspaceProperties workspaceProperties() {
        return this.workspaceProperties;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.userVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceRequest)) {
            return false;
        }
        WorkspaceRequest other = (WorkspaceRequest)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.volumeEncryptionKey(), other.volumeEncryptionKey()) && Objects.equals(this.userVolumeEncryptionEnabled(), other.userVolumeEncryptionEnabled()) && Objects.equals(this.rootVolumeEncryptionEnabled(), other.rootVolumeEncryptionEnabled()) && Objects.equals(this.workspaceProperties(), other.workspaceProperties()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"WorkspaceRequest").add("DirectoryId", (Object)this.directoryId()).add("UserName", (Object)this.userName()).add("BundleId", (Object)this.bundleId()).add("VolumeEncryptionKey", (Object)this.volumeEncryptionKey()).add("UserVolumeEncryptionEnabled", (Object)this.userVolumeEncryptionEnabled()).add("RootVolumeEncryptionEnabled", (Object)this.rootVolumeEncryptionEnabled()).add("WorkspaceProperties", (Object)this.workspaceProperties()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "VolumeEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKey()));
            }
            case "UserVolumeEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.userVolumeEncryptionEnabled()));
            }
            case "RootVolumeEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeEncryptionEnabled()));
            }
            case "WorkspaceProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceProperties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceRequest, T> g) {
        return obj -> g.apply((WorkspaceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String userName;
        private String bundleId;
        private String volumeEncryptionKey;
        private Boolean userVolumeEncryptionEnabled;
        private Boolean rootVolumeEncryptionEnabled;
        private WorkspaceProperties workspaceProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceRequest model) {
            this.directoryId(model.directoryId);
            this.userName(model.userName);
            this.bundleId(model.bundleId);
            this.volumeEncryptionKey(model.volumeEncryptionKey);
            this.userVolumeEncryptionEnabled(model.userVolumeEncryptionEnabled);
            this.rootVolumeEncryptionEnabled(model.rootVolumeEncryptionEnabled);
            this.workspaceProperties(model.workspaceProperties);
            this.tags(model.tags);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        public final Boolean getUserVolumeEncryptionEnabled() {
            return this.userVolumeEncryptionEnabled;
        }

        @Override
        public final Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
            return this;
        }

        public final void setUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
        }

        public final Boolean getRootVolumeEncryptionEnabled() {
            return this.rootVolumeEncryptionEnabled;
        }

        @Override
        public final Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
            return this;
        }

        public final void setRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return this.workspaceProperties != null ? this.workspaceProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public WorkspaceRequest build() {
            return new WorkspaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceRequest> {
        public Builder directoryId(String var1);

        public Builder userName(String var1);

        public Builder bundleId(String var1);

        public Builder volumeEncryptionKey(String var1);

        public Builder userVolumeEncryptionEnabled(Boolean var1);

        public Builder rootVolumeEncryptionEnabled(Boolean var1);

        public Builder workspaceProperties(WorkspaceProperties var1);

        default public Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return this.workspaceProperties((WorkspaceProperties)((WorkspaceProperties.Builder)WorkspaceProperties.builder().applyMutation(workspaceProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

