/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceBundle;

public class DescribeWorkspaceBundlesPublisher
implements SdkPublisher<DescribeWorkspaceBundlesResponse> {
    private final WorkSpacesAsyncClient client;
    private final DescribeWorkspaceBundlesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeWorkspaceBundlesPublisher(WorkSpacesAsyncClient client, DescribeWorkspaceBundlesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeWorkspaceBundlesPublisher(WorkSpacesAsyncClient client, DescribeWorkspaceBundlesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeWorkspaceBundlesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeWorkspaceBundlesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspaceBundle> bundles() {
        Function<DescribeWorkspaceBundlesResponse, Iterator> getIterator = response -> {
            if (response != null && response.bundles() != null) {
                return response.bundles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeWorkspaceBundlesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeWorkspaceBundlesPublisher resume(DescribeWorkspaceBundlesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeWorkspaceBundlesPublisher(this.client, (DescribeWorkspaceBundlesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeWorkspaceBundlesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeWorkspaceBundlesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeWorkspaceBundlesResponseFetcher
    implements AsyncPageFetcher<DescribeWorkspaceBundlesResponse> {
        private DescribeWorkspaceBundlesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWorkspaceBundlesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeWorkspaceBundlesResponse> nextPage(DescribeWorkspaceBundlesResponse previousPage) {
            if (previousPage == null) {
                return DescribeWorkspaceBundlesPublisher.this.client.describeWorkspaceBundles(DescribeWorkspaceBundlesPublisher.this.firstRequest);
            }
            return DescribeWorkspaceBundlesPublisher.this.client.describeWorkspaceBundles((DescribeWorkspaceBundlesRequest)((Object)DescribeWorkspaceBundlesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

