/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory;

public class DescribeWorkspaceDirectoriesIterable
implements SdkIterable<DescribeWorkspaceDirectoriesResponse> {
    private final WorkSpacesClient client;
    private final DescribeWorkspaceDirectoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeWorkspaceDirectoriesIterable(WorkSpacesClient client, DescribeWorkspaceDirectoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeWorkspaceDirectoriesResponseFetcher();
    }

    public Iterator<DescribeWorkspaceDirectoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspaceDirectory> directories() {
        Function<DescribeWorkspaceDirectoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.directories() != null) {
                return response.directories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeWorkspaceDirectoriesIterable resume(DescribeWorkspaceDirectoriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeWorkspaceDirectoriesIterable(this.client, (DescribeWorkspaceDirectoriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeWorkspaceDirectoriesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeWorkspaceDirectoriesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeWorkspaceDirectoriesResponseFetcher
    implements SyncPageFetcher<DescribeWorkspaceDirectoriesResponse> {
        private DescribeWorkspaceDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWorkspaceDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeWorkspaceDirectoriesResponse nextPage(DescribeWorkspaceDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeWorkspaceDirectoriesIterable.this.client.describeWorkspaceDirectories(DescribeWorkspaceDirectoriesIterable.this.firstRequest);
            }
            return DescribeWorkspaceDirectoriesIterable.this.client.describeWorkspaceDirectories((DescribeWorkspaceDirectoriesRequest)((Object)DescribeWorkspaceDirectoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

