/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.Workspace;

public class DescribeWorkspacesIterable
implements SdkIterable<DescribeWorkspacesResponse> {
    private final WorkSpacesClient client;
    private final DescribeWorkspacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeWorkspacesIterable(WorkSpacesClient client, DescribeWorkspacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeWorkspacesResponseFetcher();
    }

    public Iterator<DescribeWorkspacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Workspace> workspaces() {
        Function<DescribeWorkspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaces() != null) {
                return response.workspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeWorkspacesIterable resume(DescribeWorkspacesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeWorkspacesIterable(this.client, (DescribeWorkspacesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeWorkspacesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeWorkspacesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeWorkspacesResponseFetcher
    implements SyncPageFetcher<DescribeWorkspacesResponse> {
        private DescribeWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeWorkspacesResponse nextPage(DescribeWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeWorkspacesIterable.this.client.describeWorkspaces(DescribeWorkspacesIterable.this.firstRequest);
            }
            return DescribeWorkspacesIterable.this.client.describeWorkspaces((DescribeWorkspacesRequest)((Object)DescribeWorkspacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

