/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AssociationStatus {
    NOT_ASSOCIATED("NOT_ASSOCIATED"),
    ASSOCIATED_WITH_OWNER_ACCOUNT("ASSOCIATED_WITH_OWNER_ACCOUNT"),
    ASSOCIATED_WITH_SHARED_ACCOUNT("ASSOCIATED_WITH_SHARED_ACCOUNT"),
    PENDING_ASSOCIATION("PENDING_ASSOCIATION"),
    PENDING_DISASSOCIATION("PENDING_DISASSOCIATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AssociationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AssociationStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationStatus> knownValues() {
        return Stream.of(AssociationStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

