/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemIterable;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;
import software.amazon.dax.com.amazon.cbor.Utils;

public class DelegateSyncClient
implements DynamoDbClient {
    private final DynamoDbAsyncClient client;

    DelegateSyncClient(DynamoDbAsyncClient client) {
        this.client = client;
    }

    public String serviceName() {
        return "dax";
    }

    public void close() {
        this.client.close();
    }

    private <T> T handleException(Supplier<CompletableFuture<T>> task) {
        try {
            return task.get().join();
        }
        catch (CompletionException e) {
            throw Utils.rethrow(e.getCause());
        }
    }

    public BatchGetItemResponse batchGetItem(BatchGetItemRequest request) {
        return (BatchGetItemResponse)this.handleException(() -> this.client.batchGetItem(request));
    }

    public BatchWriteItemResponse batchWriteItem(BatchWriteItemRequest request) {
        return (BatchWriteItemResponse)this.handleException(() -> this.client.batchWriteItem(request));
    }

    public DeleteItemResponse deleteItem(DeleteItemRequest request) {
        return (DeleteItemResponse)this.handleException(() -> this.client.deleteItem(request));
    }

    public GetItemResponse getItem(GetItemRequest request) {
        return (GetItemResponse)this.handleException(() -> this.client.getItem(request));
    }

    public PutItemResponse putItem(PutItemRequest request) {
        return (PutItemResponse)this.handleException(() -> this.client.putItem(request));
    }

    public QueryResponse query(QueryRequest request) {
        return (QueryResponse)this.handleException(() -> this.client.query(request));
    }

    public ScanResponse scan(ScanRequest request) {
        return (ScanResponse)this.handleException(() -> this.client.scan(request));
    }

    public TransactGetItemsResponse transactGetItems(TransactGetItemsRequest request) {
        return (TransactGetItemsResponse)this.handleException(() -> this.client.transactGetItems(request));
    }

    public TransactWriteItemsResponse transactWriteItems(TransactWriteItemsRequest request) {
        return (TransactWriteItemsResponse)this.handleException(() -> this.client.transactWriteItems(request));
    }

    public UpdateItemResponse updateItem(UpdateItemRequest request) {
        return (UpdateItemResponse)this.handleException(() -> this.client.updateItem(request));
    }

    public BatchGetItemIterable batchGetItemPaginator(BatchGetItemRequest request) {
        return new BatchGetItemIterable((DynamoDbClient)this, request);
    }

    public QueryIterable queryPaginator(QueryRequest request) {
        return new QueryIterable((DynamoDbClient)this, request);
    }

    public ScanIterable scanPaginator(ScanRequest request) {
        return new ScanIterable((DynamoDbClient)this, request);
    }
}

