/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax.bits;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import software.amazon.dax.com.amazon.cbor.CborInputStream;

public class DaxCborInputStream
extends CborInputStream {
    private static final EnumMap EMPTY_MAP = new EmptyEnumMap(NoEnum.class);

    public DaxCborInputStream(InputStream in) {
        super(in);
    }

    public DaxCborInputStream(InputStream in, int bufferSize) {
        super(in, bufferSize);
    }

    public DaxCborInputStream(InputStream in, byte[] buffer, int offset, int length) {
        super(in, buffer, offset, length);
    }

    public DaxCborInputStream(byte[] src) {
        super(src);
    }

    public DaxCborInputStream(byte[] src, int offset) {
        super(src, offset);
    }

    public DaxCborInputStream(byte[] src, int offset, int length) {
        super(src, offset, length);
    }

    public <T extends Enum<T>> EnumMap<T, Object> readEnumMap(Class<T> keyType, T[] enums) throws IOException {
        this.skipTags();
        if (this.tryReadNull()) {
            return null;
        }
        EnumMap<T, Object> result = null;
        int i = this.streamMapLength();
        while (this.itemsRemaining(i)) {
            if (result == null) {
                result = new EnumMap<T, Object>(keyType);
            }
            result.put(enums[this.readInt()], this.readObject());
            --i;
        }
        return result != null ? result : EMPTY_MAP;
    }

    public boolean itemsRemaining(int items) throws IOException {
        if (items < 0 && this.fieldType() == 255) {
            this.consumeField();
            return false;
        }
        return items != 0;
    }

    public int streamMapLength() throws IOException {
        int type = this.fieldType();
        if (!DaxCborInputStream.isMap(type)) {
            throw new IllegalStateException("Current value is not a map");
        }
        if (DaxCborInputStream.isStream(type)) {
            this.consumeField();
            return -1;
        }
        return this.readMapLength();
    }

    public int streamArrayLength() throws IOException {
        int type = this.fieldType();
        if (!DaxCborInputStream.isArray(type)) {
            throw new IllegalStateException("Current value is not an array");
        }
        if (DaxCborInputStream.isStream(type)) {
            this.consumeField();
            return -1;
        }
        return this.readArrayLength();
    }

    public static boolean isArray(int type) {
        return type >> 5 == 4;
    }

    public static boolean isMap(int type) {
        return type >> 5 == 5;
    }

    public static boolean isStream(int type) {
        return (type & 0x1F) == 31;
    }

    public boolean skipTags() throws IOException {
        int type;
        boolean tagsFound = false;
        while ((type = this.fieldType()) >> 5 == 6) {
            this.consumeField();
            tagsFound = true;
        }
        return tagsFound;
    }

    public boolean tryReadNull() throws IOException {
        this.skipTags();
        int type = this.fieldType();
        if (type == 246) {
            this.consumeField();
            return true;
        }
        return false;
    }

    private static final class EmptyEnumMap<K extends Enum<K>, V>
    extends EnumMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594321L;

        EmptyEnumMap(Class<K> klass) {
            super(klass);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static enum NoEnum {
        none;

    }
}

