/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax.bits;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import software.amazon.dax.com.amazon.cbor.Decoder;
import software.amazon.dax.com.amazon.cbor.IntRef;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.cbor.Utils;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;

public final class LexDecimal {
    static final byte NULL_BYTE_LOW = 0;
    static final byte NULL_BYTE_HIGH = -1;
    static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);
    private static final double LOG_1000_MULTIPLIER = Math.log(2.0) / Math.log(1000.0);

    private LexDecimal() {
    }

    public static SegmentPool.Segment encode(BigDecimal value, SegmentPool pool, SegmentPool.Segment dst) {
        return LexDecimal.encode(value, pool, dst, 0);
    }

    public static SegmentPool.Segment encodeDesc(BigDecimal value, SegmentPool pool, SegmentPool.Segment dst) {
        return LexDecimal.encode(value, pool, dst, -1);
    }

    private static SegmentPool.Segment encode(BigDecimal value, SegmentPool pool, SegmentPool.Segment dst, int xorMask) {
        int end;
        byte[] encoded;
        if (value == null) {
            return pool.chainAppend(dst, (byte)(0xFFFFFFFF ^ xorMask));
        }
        if (value.signum() == 0) {
            return pool.chainAppend(dst, (byte)(0x80 ^ xorMask));
        }
        int length = LexDecimal.estimateLength(value);
        if (length <= (encoded = dst.mBytes).length - (end = dst.mEnd)) {
            dst.mEnd = LexDecimal.encode(value, encoded, end, xorMask);
            return dst;
        }
        encoded = new byte[length];
        length = LexDecimal.encode(value, encoded, 0, xorMask);
        return pool.chainAppend(dst, encoded, 0, length);
    }

    private static int estimateLength(BigDecimal value) {
        long digits = 2L + (long)Math.ceil((double)value.unscaledValue().bitLength() * LOG_1000_MULTIPLIER);
        return (int)(5L + (digits * 10L + 7L >> 3));
    }

    public static byte[] encode(BigDecimal value, int xorMask) {
        if (value == null) {
            throw new IllegalArgumentException("NULL big decimal is not valid key value");
        }
        if (value.signum() == 0) {
            byte[] encoded = new byte[]{(byte)(0x80 ^ xorMask)};
            return encoded;
        }
        byte[] encoded = new byte[LexDecimal.estimateLength(value)];
        int offset = LexDecimal.encode(value, encoded, 0, xorMask);
        if (offset == encoded.length) {
            return encoded;
        }
        return Arrays.copyOf(encoded, offset);
    }

    private static int encode(BigDecimal value, byte[] dst, int dstOffset, int xorMask) {
        int digitAdjust;
        int terminator;
        int precision = value.precision();
        int exponent = precision - value.scale();
        if (value.signum() < 0) {
            if (exponent >= -62 && exponent < 62) {
                dst[dstOffset++] = (byte)(63 - exponent ^ xorMask);
            } else {
                dst[dstOffset] = exponent < 0 ? (byte)(0x7E ^ xorMask) : (byte)(1 ^ xorMask);
                Utils.encodeIntBE(dst, dstOffset + 1, exponent ^ xorMask ^ Integer.MAX_VALUE);
                dstOffset += 5;
            }
        } else if (exponent >= -62 && exponent < 62) {
            dst[dstOffset++] = (byte)(exponent + 192 ^ xorMask);
        } else {
            dst[dstOffset] = exponent < 0 ? (byte)(0x81 ^ xorMask) : (byte)(0xFE ^ xorMask);
            Utils.encodeIntBE(dst, dstOffset + 1, exponent ^ xorMask ^ Integer.MIN_VALUE);
            dstOffset += 5;
        }
        BigInteger unscaledValue = value.unscaledValue();
        switch (precision % 3) {
            default: {
                terminator = 2;
                break;
            }
            case 1: {
                terminator = 0;
                unscaledValue = unscaledValue.multiply(ONE_HUNDRED);
                break;
            }
            case 2: {
                terminator = 1;
                unscaledValue = unscaledValue.multiply(BigInteger.TEN);
            }
        }
        if (unscaledValue.signum() >= 0) {
            digitAdjust = 12;
        } else {
            digitAdjust = 1011;
            terminator = 1023 - terminator;
        }
        int pos = (unscaledValue.bitLength() + 9) / 10 + 1;
        int[] digits = new int[pos];
        digits[--pos] = terminator;
        while (unscaledValue.signum() != 0) {
            BigInteger[] divrem = unscaledValue.divideAndRemainder(ONE_THOUSAND);
            if (--pos < 0) {
                int[] newDigits = new int[digits.length + 1];
                System.arraycopy(digits, 0, newDigits, 1, digits.length);
                digits = newDigits;
                pos = 0;
            }
            digits[pos] = divrem[1].intValue() + digitAdjust;
            unscaledValue = divrem[0];
        }
        int accum = 0;
        int bits = 0;
        for (int i = 0; i < digits.length; ++i) {
            accum = accum << 10 | digits[i];
            bits += 10;
            do {
                dst[dstOffset++] = (byte)(accum >> (bits -= 8) ^ xorMask);
            } while (bits >= 8);
        }
        if (bits != 0) {
            dst[dstOffset++] = (byte)(accum << 8 - bits ^ xorMask);
        }
        return dstOffset;
    }

    public static int decode(byte[] src, int srcOffset, BigDecimal[] valueRef) {
        return LexDecimal.decode(src, srcOffset, valueRef, 0);
    }

    public static int decodeDesc(byte[] src, int srcOffset, BigDecimal[] valueRef) {
        return LexDecimal.decode(src, srcOffset, valueRef, -1);
    }

    private static int decode(byte[] src, int srcOffset, BigDecimal[] valueRef, int xorMask) {
        int exponent;
        int digitAdjust;
        int originalOffset = srcOffset;
        int header = (src[srcOffset] ^ xorMask) & 0xFF;
        switch (header) {
            case 0: 
            case 255: {
                valueRef[0] = null;
                return 1;
            }
            case 127: 
            case 128: {
                valueRef[0] = BigDecimal.ZERO;
                return 1;
            }
            case 1: 
            case 126: {
                digitAdjust = 1011;
                exponent = Utils.decodeIntBE(src, srcOffset + 1) ^ xorMask ^ Integer.MAX_VALUE;
                srcOffset += 5;
                break;
            }
            case 129: 
            case 254: {
                digitAdjust = 12;
                exponent = Utils.decodeIntBE(src, srcOffset + 1) ^ xorMask ^ Integer.MIN_VALUE;
                srcOffset += 5;
                break;
            }
            default: {
                exponent = (src[srcOffset++] ^ xorMask) & 0xFF;
                if (exponent >= 130) {
                    digitAdjust = 12;
                    exponent -= 192;
                    break;
                }
                digitAdjust = 1011;
                exponent = 63 - exponent;
            }
        }
        BigInteger unscaledValue = null;
        int precision = 0;
        int accum = 0;
        int bits = 0;
        BigInteger lastDigit = null;
        block11: while (true) {
            accum = accum << 8 | (src[srcOffset++] ^ xorMask) & 0xFF;
            if ((bits += 8) < 10) continue;
            int digit = accum >> bits - 10 & 0x3FF;
            switch (digit) {
                case 0: 
                case 1023: {
                    lastDigit = lastDigit.divide(ONE_HUNDRED);
                    unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(BigInteger.TEN).add(lastDigit);
                    ++precision;
                    break block11;
                }
                case 1: 
                case 1022: {
                    lastDigit = lastDigit.divide(BigInteger.TEN);
                    unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(ONE_HUNDRED).add(lastDigit);
                    precision += 2;
                    break block11;
                }
                case 2: 
                case 1021: {
                    unscaledValue = unscaledValue == null ? lastDigit : unscaledValue.multiply(ONE_THOUSAND).add(lastDigit);
                    precision += 3;
                    break block11;
                }
                default: {
                    if (unscaledValue == null) {
                        unscaledValue = lastDigit;
                        if (unscaledValue != null) {
                            precision += 3;
                        }
                    } else {
                        unscaledValue = unscaledValue.multiply(ONE_THOUSAND).add(lastDigit);
                        precision += 3;
                    }
                    bits -= 10;
                    lastDigit = BigInteger.valueOf(digit - digitAdjust);
                    continue block11;
                }
            }
            break;
        }
        int scale = precision - exponent;
        valueRef[0] = new BigDecimal(unscaledValue, scale);
        return srcOffset - originalOffset;
    }

    public static SegmentPool.Segment convertToDecimal(byte[] src, IntRef srcOffsetRef, SegmentPool pool, SegmentPool.Segment dst) {
        return LexDecimal.convertToDecimal(src, srcOffsetRef, pool, dst, 0);
    }

    public static SegmentPool.Segment convertToDecimalDesc(byte[] src, IntRef srcOffsetRef, SegmentPool pool, SegmentPool.Segment dst) {
        return LexDecimal.convertToDecimal(src, srcOffsetRef, pool, dst, -1);
    }

    private static SegmentPool.Segment convertToDecimal(byte[] src, IntRef srcOffsetRef, SegmentPool pool, SegmentPool.Segment dst, int xorMask) {
        BigDecimal value = Decoder.decodeCborBigDecimal(src, srcOffsetRef);
        if (value == null) {
            return null;
        }
        return LexDecimal.encode(value, pool, dst, xorMask);
    }

    public static SegmentPool.Segment convertToCbor(byte[] src, IntRef srcOffsetRef, SegmentPool pool, SegmentPool.Segment dst) {
        return LexDecimal.convertToCbor(src, srcOffsetRef, pool, dst, 0);
    }

    public static SegmentPool.Segment convertDescToCbor(byte[] src, IntRef srcOffsetRef, SegmentPool pool, SegmentPool.Segment dst) {
        return LexDecimal.convertToCbor(src, srcOffsetRef, pool, dst, -1);
    }

    public static SegmentPool.Segment convertToCbor(byte[] src, IntRef srcOffsetRef, SegmentPool pool, SegmentPool.Segment dst, int xorMask) {
        BigDecimal[] ref = new BigDecimal[1];
        int srcOffset = srcOffsetRef.value;
        srcOffsetRef.value = srcOffset + LexDecimal.decode(src, srcOffset, ref, xorMask);
        return pool.chainAppendCborDecimal(dst, ref[0]);
    }
}

