/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.cbor.Utils;
import software.amazon.dax.com.amazon.dax.bits.LexDecimal;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.expr.ExpressionType;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.ExceptionTranslator;
import software.amazon.dax.expr.CborSExprGenerator;

public final class AttributeValueEncoder {
    private AttributeValueEncoder() {
    }

    public static Map<ExpressionType, byte[]> encodeExpressions(String condExpr, String keyCondExpr, String filterExpr, String updateExpr, String projExpr, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        Map<String, AttributeValue> eAttrNames = eAttrStrs == null ? Collections.emptyMap() : CborSExprGenerator.convertExpressionAttributeNames(eAttrStrs);
        eAttrVals = eAttrVals == null ? Collections.emptyMap() : eAttrVals;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, eAttrVals);
        return CborSExprGenerator.encodeExpressions(condExpr, keyCondExpr, filterExpr, updateExpr, projExpr, eAttrNames, eAttrVals);
    }

    public static byte[] encodeConditionalExp(String condExp, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        if (condExp == null || condExp.isEmpty()) {
            return null;
        }
        eAttrStrs = eAttrStrs == null ? Collections.emptyMap() : eAttrStrs;
        eAttrVals = eAttrVals == null ? Collections.emptyMap() : eAttrVals;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, eAttrVals);
        return CborSExprGenerator.encodeConditionalExprWithStringAttrNames(condExp, eAttrStrs, eAttrVals);
    }

    public static byte[] encodeConditionalExp(DynamoDBExpressionInfo info) {
        return AttributeValueEncoder.encodeConditionalExp(info.getConditionExpression(), info.getExpressionAttributeNames(), info.getExpressionAttributeValues());
    }

    public static byte[] encodeProjection(String projExp, Map<String, String> eAttrStrs) {
        if (projExp == null || projExp.isEmpty()) {
            return null;
        }
        eAttrStrs = eAttrStrs == null ? Collections.emptyMap() : eAttrStrs;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, null);
        return CborSExprGenerator.encodeProjectionExpression(projExp, eAttrStrs);
    }

    public static byte[] encodeUpdateExpression(String updateExp, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        if (updateExp == null || updateExp.isEmpty()) {
            return null;
        }
        eAttrStrs = eAttrStrs == null ? Collections.emptyMap() : eAttrStrs;
        eAttrVals = eAttrVals == null ? Collections.emptyMap() : eAttrVals;
        AttributeValueEncoder.checkValidExprParamNames(eAttrStrs, eAttrVals);
        return CborSExprGenerator.encodeUpdateExpression(updateExp, eAttrStrs, eAttrVals);
    }

    protected static SegmentPool.Segment encodeCompoundKey(SegmentPool pool, SegmentPool.Segment segment, Map<String, AttributeValue> attrs) throws IOException {
        segment = pool.chainAppendCborMapStreamPrefix(segment);
        if (attrs != null) {
            for (Map.Entry<String, AttributeValue> key : attrs.entrySet()) {
                segment = pool.chainAppendCborString(segment, key.getKey());
                if (key.getValue() == null) {
                    throw new IllegalArgumentException("Not enough fields to construct compound key");
                }
                segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, key.getValue());
            }
        }
        segment = pool.chainAppendCborStreamBreak(segment);
        return segment;
    }

    protected static SegmentPool.Segment validateAndEncodeKey(SegmentPool pool, SegmentPool.Segment segment, Map<String, AttributeValue> item, List<AttributeDefinition> keys) throws IOException {
        RequestValidator.validateKey(item, keys);
        return AttributeValueEncoder.encodeKey(pool, segment, item, keys);
    }

    protected static SegmentPool.Segment encodeKey(SegmentPool pool, SegmentPool.Segment segment, Map<String, AttributeValue> item, List<AttributeDefinition> keys) throws IOException {
        if (item == null) {
            throw ExceptionTranslator.createValidationException("Cannot have null item");
        }
        AttributeDefinition ad = keys.get(0);
        AttributeValue av = item.get(ad.attributeName());
        if (av == null) {
            throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
        }
        if (keys.size() == 2) {
            String n;
            ByteBuffer b;
            String s;
            switch (ad.attributeTypeAsString()) {
                case "S": {
                    s = av.s();
                    if (s == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppendCborString(segment, s);
                    break;
                }
                case "B": {
                    b = av.b().asByteBuffer();
                    if (b == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppendCborBinary(segment, b);
                    break;
                }
                case "N": {
                    n = av.n();
                    if (n == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    try {
                        segment = pool.chainAppendCborNumberString(segment, n);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported KeyType encountered in Hash Attribute: " + ad);
                }
            }
            ad = keys.get(1);
            av = item.get(ad.attributeName());
            if (av == null) {
                throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
            }
            switch (ad.attributeTypeAsString()) {
                case "S": {
                    s = av.s();
                    if (s == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, Encoder.encodeUtf8(s));
                    break;
                }
                case "B": {
                    b = av.b().asByteBuffer();
                    if (b == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, b);
                    break;
                }
                case "N": {
                    n = av.n();
                    if (n == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    try {
                        segment = pool.chainAppend(segment, LexDecimal.encode(new BigDecimal(n), 0));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported KeyType encountered in Range Attribute: " + ad);
                }
            }
        } else {
            switch (ad.attributeTypeAsString()) {
                case "S": {
                    String s = av.s();
                    if (s == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, Encoder.encodeUtf8(s));
                    break;
                }
                case "B": {
                    ByteBuffer b = av.b().asByteBuffer();
                    if (b == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    segment = pool.chainAppend(segment, b);
                    break;
                }
                case "N": {
                    String n = av.n();
                    if (n == null) {
                        throw ExceptionTranslator.createValidationException("One of the required keys was not given a value");
                    }
                    try {
                        segment = pool.chainAppendCborNumberString(segment, n);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported KeyType encountered in Hash Attribute: " + ad);
                }
            }
        }
        return segment;
    }

    public static SegmentPool.Segment encodeAttributeValue(SegmentPool pool, SegmentPool.Segment segment, AttributeValue value) {
        if (value.s() != null) {
            return pool.chainAppendCborString(segment, value.s());
        }
        if (value.n() != null) {
            try {
                return pool.chainAppendCborNumberString(segment, value.n());
            }
            catch (NumberFormatException e) {
                throw ExceptionTranslator.createValidationException("A value provided cannot be converted into a number");
            }
        }
        if (value.b() != null) {
            return pool.chainAppendCborBinary(segment, value.b().asByteBuffer());
        }
        if (value.hasSs()) {
            if (value.ss().isEmpty()) {
                throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes");
            }
            return pool.chainAppendCborStringSet(segment, value.ss());
        }
        if (value.hasNs()) {
            if (value.ns().isEmpty()) {
                throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes");
            }
            return pool.chainAppendCborNumberSet(segment, value.ns());
        }
        if (value.hasBs()) {
            if (value.bs().isEmpty()) {
                throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes");
            }
            return pool.chainAppendCborBinarySet(segment, value.bs().stream().map(b -> b.asByteBuffer()).collect(Collectors.toList()));
        }
        if (value.hasM()) {
            segment = pool.chainAppendCborMapPrefix(segment, value.m().size());
            for (Map.Entry e : value.m().entrySet()) {
                segment = pool.chainAppendCborString(segment, (String)e.getKey());
                segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, (AttributeValue)e.getValue());
            }
            return segment;
        }
        if (value.hasL()) {
            segment = pool.chainAppendCborArrayPrefix(segment, value.l().size());
            for (AttributeValue av : value.l()) {
                segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, av);
            }
            return segment;
        }
        if (value.nul() != null) {
            return pool.chainAppend(segment, (byte)-10);
        }
        if (value.bool() != null) {
            if (value.bool().booleanValue()) {
                return pool.chainAppend(segment, (byte)-11);
            }
            return pool.chainAppend(segment, (byte)-12);
        }
        throw ExceptionTranslator.createValidationException("Supplied AttributeValue is empty, must contain exactly one of the supported datatypes" + value.toString());
    }

    public static CompletableFuture<Integer> encodeAttributes(Map<String, AttributeValue> attrs, List<AttributeDefinition> keys, SimpleCache<List<String>, Long> cache, SegmentPool pool, SegmentPool.Segment segment) throws IOException {
        return AttributeValueEncoder.getAttributeListId(attrs, keys, cache, null, -1).thenApply(attributeListId -> {
            try {
                return AttributeValueEncoder.encodeAttributes(attrs, keys, attributeListId, pool, segment);
            }
            catch (IOException ioException) {
                throw new CompletionException(ioException);
            }
        });
    }

    public static int encodeAttributes(Map<String, AttributeValue> attrs, List<AttributeDefinition> keys, Long attributeListId, SegmentPool pool, SegmentPool.Segment segment) throws IOException {
        SegmentPool.Segment headSegment = pool.chainRequire(segment, 9);
        headSegment.mEnd += 9;
        int offset = headSegment.mEnd;
        HashSet<String> keySet = new HashSet<String>();
        for (AttributeDefinition ad : keys) {
            keySet.add(ad.attributeName());
        }
        TreeMap<String, AttributeValue> sortedAttrs = new TreeMap<String, AttributeValue>(attrs);
        for (Map.Entry<String, AttributeValue> e : sortedAttrs.entrySet()) {
            String attrName = e.getKey();
            if (keySet.contains(attrName)) continue;
            AttributeValue val = e.getValue();
            segment = AttributeValueEncoder.encodeAttributeValue(pool, segment, val);
        }
        return Encoder.prependCborInteger(headSegment.mBytes, offset, attributeListId);
    }

    public static CompletableFuture<Long> getAttributeListId(Map<String, AttributeValue> attrs, List<AttributeDefinition> keys, SimpleCache<List<String>, Long> cache, Long[] attributeListIds, int index) {
        HashSet<String> keySet = new HashSet<String>();
        for (AttributeDefinition ad : keys) {
            keySet.add(ad.attributeName());
        }
        TreeMap<String, AttributeValue> sortedAttrs = new TreeMap<String, AttributeValue>(attrs);
        ArrayList<String> attrNames = new ArrayList<String>(attrs.size());
        for (Map.Entry<String, AttributeValue> e : sortedAttrs.entrySet()) {
            String attrName = e.getKey();
            if (keySet.contains(attrName)) continue;
            attrNames.add(attrName);
            if (e.getValue() != null) continue;
            throw ExceptionTranslator.createValidationException("The supplied Item contains a null AttributeValue: " + attrName + " is null");
        }
        return cache.get(attrNames).thenApply(attributeListId -> {
            if (attributeListIds != null) {
                attributeListIds[index] = attributeListId;
            }
            return attributeListId;
        });
    }

    private static void checkValidExprParamNames(Map<String, String> eAttrNames, Map<String, AttributeValue> eAttrVals) {
        if (eAttrVals != null) {
            AttributeValueEncoder.checkExprParams(eAttrVals.keySet(), true);
        }
        if (eAttrNames != null) {
            AttributeValueEncoder.checkExprParams(eAttrNames.keySet(), false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static void checkExprParams(Set<String> keyNames, boolean isExprAttrVals) {
        String s;
        char prefix = isExprAttrVals ? (char)':' : '#';
        if (keyNames == null) return;
        Iterator<String> iterator = keyNames.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) return;
            s = iterator.next();
            int i = 0;
            if (s.length() <= 1 || s.charAt(i++) != prefix) break;
            while (true) {
                if (i >= s.length()) continue block0;
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) break block0;
                ++i;
            }
            break;
        }
        if (!isExprAttrVals) throw ExceptionTranslator.createValidationException("ExpressionAttributeNames contains invalid key: \"" + s + "\"");
        throw ExceptionTranslator.createValidationException("ExpressionAttributeValues contains invalid key: \"" + s + "\"");
    }

    public static Map<Integer, DocumentPath> prepareProjection(DynamoDBExpressionInfo info, Map<Integer, DocumentPath> ords) {
        AttributeValueEncoder.prepareProjection(info.getProjectionExpression(), info.getExpressionAttributeNames(), ords);
        return ords;
    }

    public static void prepareProjection(String expression, Map<String, String> attributeNames, Map<Integer, DocumentPath> ords) {
        if (expression == null) {
            return;
        }
        String[] projectionTerms = expression.split(",");
        for (int i = 0; i < projectionTerms.length; ++i) {
            ords.put(i, DocumentPath.from(projectionTerms[i].trim(), attributeNames));
        }
    }

    public static enum UnsignedComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] a, byte[] b) {
            return Utils.compareUnsigned(a, b);
        }
    }
}

