/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Get;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.exceptions.ExceptionTranslator;
import software.amazon.dax.expr.ExpressionValidationModel;

public class TransactGetItemsRequestEncoder
extends RequestEncoder<TransactGetItemsRequest> {
    private static final String TXN_VALIDATION_ERROR_MSG = "transactItems.%d.member.%s.%s";
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> cache;
    private final AtomicReference<List<Map<Integer, DocumentPath>>> projectionOrdinalsPerRequest;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable;
    private final AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest;

    public TransactGetItemsRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> cache, AtomicReference<List<Map<Integer, DocumentPath>>> projectionOrdinalsPerRequest, AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable, AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest) {
        this.segmentPool = segmentPool;
        this.cache = cache;
        this.projectionOrdinalsPerRequest = projectionOrdinalsPerRequest;
        this.keyDefPerTable = keyDefPerTable;
        this.keysPerRequest = keysPerRequest;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, TransactGetItemsRequest request, ChannelPromise promise) throws Exception {
        if (!request.hasTransactItems()) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value null at 'transactItems' failed to satisfy constraint: Member must not be null");
        }
        if (request.transactItems().size() < 1) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.transactItems() + "' at 'transactItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
        }
        HashMap tableKeysMap = new HashMap();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        int i = 0;
        for (TransactGetItem transactGetItem : request.transactItems()) {
            if (transactGetItem == null) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.transactItems() + "' at 'transactItems' failed to satisfy constraint: Member must not be null");
            }
            if (transactGetItem.get() == null) {
                throw ExceptionTranslator.createValidationException("Invalid Request: TransactWriteRequest should contain Get request");
            }
            Get get = transactGetItem.get();
            Map key = get.key();
            String tableName = get.tableName();
            String projectionExpr = get.projectionExpression();
            RequestValidator.validateTableName(tableName, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "get", "tableName"));
            RequestValidator.validateTransactItem(key, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "get", "key"));
            RequestValidator.validateExpression(new ExpressionValidationModel().projectionExpression(projectionExpr).expressionAttributeNames(get.hasExpressionAttributeNames() ? get.expressionAttributeNames() : null));
            futures.add(this.cache.get(tableName).thenApply(tableKeys -> {
                tableKeysMap.put(tableName, tableKeys);
                return null;
            }));
            ++i;
        }
        CompletableFuture[] futuresArray = futures.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(futuresArray).whenComplete((placeholder, ex) -> {
            if (ex != null) {
                promise.setFailure(ex);
            } else {
                try {
                    this.encodeAndWrite(ctx, request, promise, tableKeysMap);
                }
                catch (Exception exception) {
                    promise.setFailure((Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndWrite(ChannelHandlerContext ctx, TransactGetItemsRequest request, ChannelPromise promise, Map<String, List<AttributeDefinition>> tableKeysMap) throws Exception {
        SegmentPool.Segment projectionExprsTail;
        SegmentPool.Segment tableNamesTail;
        SegmentPool.Segment keysTail;
        SegmentPool.Segment singleKeyHead = this.segmentPool.alloc();
        SegmentPool.Segment keysHead = keysTail = this.segmentPool.alloc();
        SegmentPool.Segment tableNamesHead = tableNamesTail = this.segmentPool.alloc();
        SegmentPool.Segment projectionExprsHead = projectionExprsTail = this.segmentPool.alloc();
        this.projectionOrdinalsPerRequest.compareAndSet(null, new ArrayList(request.transactItems().size()));
        this.keyDefPerTable.compareAndSet(null, new HashMap());
        this.keysPerRequest.compareAndSet(null, new ArrayList(request.transactItems().size()));
        ByteBuf buffer = ctx.alloc().buffer();
        DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);
        try {
            keysTail = this.segmentPool.chainAppendCborArrayPrefix(keysTail, request.transactItems().size());
            tableNamesTail = this.segmentPool.chainAppendCborArrayPrefix(tableNamesTail, request.transactItems().size());
            projectionExprsTail = this.segmentPool.chainAppendCborArrayPrefix(projectionExprsTail, request.transactItems().size());
            for (TransactGetItem transactGetItem : request.transactItems()) {
                Get get = transactGetItem.get();
                Map key = get.key();
                String tableName = get.tableName();
                String projectionExpr = get.projectionExpression();
                List<AttributeDefinition> tableKeys = tableKeysMap.get(tableName);
                this.keyDefPerTable.get().put(tableName, tableKeys);
                this.keysPerRequest.get().add(key);
                AttributeValueEncoder.validateAndEncodeKey(this.segmentPool, singleKeyHead, key, tableKeys);
                keysTail = this.segmentPool.chainAppendCborBytes(keysTail, this.segmentPool.chainCopyAndTrim(singleKeyHead, 0));
                tableNamesTail = this.segmentPool.chainAppendCborBytes(tableNamesTail, Encoder.encodeUtf8(tableName));
                if (projectionExpr != null) {
                    HashMap<Integer, DocumentPath> projectionOrdinals = new HashMap<Integer, DocumentPath>();
                    AttributeValueEncoder.prepareProjection(projectionExpr, get.expressionAttributeNames(), projectionOrdinals);
                    this.projectionOrdinalsPerRequest.get().add(projectionOrdinals);
                    projectionExprsTail = this.segmentPool.chainAppendCborBytes(projectionExprsTail, AttributeValueEncoder.encodeProjection(projectionExpr, get.expressionAttributeNames()));
                    continue;
                }
                projectionExprsTail = this.segmentPool.chainAppendCborNull(projectionExprsTail);
                this.projectionOrdinalsPerRequest.get().add(null);
            }
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
            byte[] kwargs = DaxRequestEncoder.encodeItemOperationsOptionalParams(DynamoNumerals.ReturnValue.NONE.mCode, returnConsumedCapacity.mCode, DynamoNumerals.ReturnItemCollectionMetrics.NONE.mCode, null, null, null, this.segmentPool);
            byte[] projectionExpressions = this.segmentPool.chainCopyAndTrim(projectionExprsHead, 0);
            out.writeInt(1);
            out.writeInt(1866287579);
            out.write(this.segmentPool.chainCopyAndTrim(tableNamesHead, 0));
            out.write(this.segmentPool.chainCopyAndTrim(keysHead, 0));
            if (projectionExpressions == null) {
                out.writeNull();
            } else {
                out.write(projectionExpressions);
            }
            if (kwargs == null) {
                out.writeNull();
            } else {
                out.write(kwargs);
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
        finally {
            this.segmentPool.recycle(singleKeyHead);
            this.segmentPool.recycle(keysHead);
            this.segmentPool.recycle(tableNamesHead);
            this.segmentPool.recycle(projectionExprsHead);
            out.close();
        }
    }
}

