/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common;

import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public interface AWSCompressionHandler {
    public static final int BUFFER_SIZE = 1024;

    public static byte[] writeToDeflatorObject(byte[] record, Deflater deflater) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(record.length);
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        return outputStream.toByteArray();
    }

    public static Deflater getDeflatorObject(byte[] record) {
        Deflater deflater = new Deflater();
        deflater.setInput(record);
        deflater.finish();
        return deflater;
    }

    public static Inflater getInflatorObject(byte[] compressedRecord, int start, int end) {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedRecord, start, end);
        return inflater;
    }

    public static byte[] decompress(Inflater inflater, int size) throws IOException {
        return AWSCompressionHandler.writeToByteArrayOutputStream(inflater, new ByteArrayOutputStream(size));
    }

    public static byte[] writeToByteArrayOutputStream(Inflater inflater, ByteArrayOutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count;
            try {
                count = inflater.inflate(buffer);
            }
            catch (DataFormatException e) {
                String message = "Bytes received is not compressed properly";
                throw new AWSSchemaRegistryException(message, e);
            }
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        return outputStream.toByteArray();
    }

    default public byte[] compress(byte[] record) throws IOException {
        return AWSCompressionHandler.writeToDeflatorObject(record, AWSCompressionHandler.getDeflatorObject(record));
    }

    default public byte[] decompress(byte[] compressedRecord, int start, int end) throws IOException {
        return AWSCompressionHandler.decompress(AWSCompressionHandler.getInflatorObject(compressedRecord, start, end), compressedRecord.length);
    }
}

