/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;
import software.amazon.lambda.powertools.logging.internal.PowertoolsLoggedFields;
import software.amazon.lambda.powertools.logging.logback.JsonUtils;

public class LambdaEcsEncoder
extends EncoderBase<ILoggingEvent> {
    protected static final String TIMESTAMP_ATTR_NAME = "@timestamp";
    protected static final String ECS_VERSION_ATTR_NAME = "ecs.version";
    protected static final String LOGGER_ATTR_NAME = "log.logger";
    protected static final String LEVEL_ATTR_NAME = "log.level";
    protected static final String SERVICE_NAME_ATTR_NAME = "service.name";
    protected static final String SERVICE_VERSION_ATTR_NAME = "service.version";
    protected static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    protected static final String THREAD_ATTR_NAME = "process.thread.name";
    protected static final String EXCEPTION_MSG_ATTR_NAME = "error.message";
    protected static final String EXCEPTION_CLASS_ATTR_NAME = "error.type";
    protected static final String EXCEPTION_STACK_ATTR_NAME = "error.stack_trace";
    protected static final String CLOUD_PROVIDER_ATTR_NAME = "cloud.provider";
    protected static final String CLOUD_REGION_ATTR_NAME = "cloud.region";
    protected static final String CLOUD_ACCOUNT_ATTR_NAME = "cloud.account.id";
    protected static final String CLOUD_SERVICE_ATTR_NAME = "cloud.service.name";
    protected static final String FUNCTION_COLD_START_ATTR_NAME = "faas.coldstart";
    protected static final String FUNCTION_REQUEST_ID_ATTR_NAME = "faas.execution";
    protected static final String FUNCTION_ARN_ATTR_NAME = "faas.id";
    protected static final String FUNCTION_NAME_ATTR_NAME = "faas.name";
    protected static final String FUNCTION_VERSION_ATTR_NAME = "faas.version";
    protected static final String FUNCTION_MEMORY_ATTR_NAME = "faas.memory";
    protected static final String FUNCTION_TRACE_ID_ATTR_NAME = "trace.id";
    protected static final String CORRELATION_ID_ATTR_NAME = "correlation.id";
    protected static final String ECS_VERSION = "1.2.0";
    protected static final String CLOUD_PROVIDER = "aws";
    protected static final String CLOUD_SERVICE = "lambda";
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    protected ThrowableHandlingConverter throwableConverter = null;
    private boolean includeCloudInfo = true;
    private boolean includeFaasInfo = true;

    public byte[] headerBytes() {
        return new byte[0];
    }

    public byte[] encode(ILoggingEvent event) {
        Map mdcPropertyMap = event.getMDCPropertyMap();
        StringBuilder builder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JsonSerializer serializer = new JsonSerializer(builder);){
                serializer.writeStartObject();
                JsonUtils.serializeTimestamp(serializer, event.getTimeStamp(), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "UTC", TIMESTAMP_ATTR_NAME);
                serializer.writeRaw(',');
                serializer.writeStringField(ECS_VERSION_ATTR_NAME, ECS_VERSION);
                serializer.writeRaw(',');
                serializer.writeStringField(LEVEL_ATTR_NAME, event.getLevel().toString());
                serializer.writeRaw(',');
                serializer.writeStringField(FORMATTED_MESSAGE_ATTR_NAME, event.getFormattedMessage());
                this.serializeException(event, serializer);
                serializer.writeRaw(',');
                serializer.writeStringField(SERVICE_NAME_ATTR_NAME, LambdaHandlerProcessor.serviceName());
                serializer.writeRaw(',');
                serializer.writeStringField(SERVICE_VERSION_ATTR_NAME, (String)mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_VERSION.getName()));
                serializer.writeRaw(',');
                serializer.writeStringField(LOGGER_ATTR_NAME, event.getLoggerName());
                serializer.writeRaw(',');
                serializer.writeStringField(THREAD_ATTR_NAME, event.getThreadName());
                String arn = (String)mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_ARN.getName());
                this.serializeCloudInfo(serializer, arn);
                this.serializeFunctionInfo(serializer, arn, mdcPropertyMap);
                JsonUtils.serializeMDCEntries(mdcPropertyMap, serializer);
                JsonUtils.serializeArguments(event, serializer);
                serializer.writeEndObject();
                serializer.writeRaw('\n');
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.printf("Failed to encode log event, error: %s.%n", e.getMessage());
        }
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void serializeFunctionInfo(JsonSerializer serializer, String arn, Map<String, String> mdcPropertyMap) {
        if (this.includeFaasInfo) {
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_ARN_ATTR_NAME, arn);
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_NAME_ATTR_NAME, mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_NAME.getName()));
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_VERSION_ATTR_NAME, mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_VERSION.getName()));
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_MEMORY_ATTR_NAME, mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_MEMORY_SIZE.getName()));
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_REQUEST_ID_ATTR_NAME, mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_REQUEST_ID.getName()));
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_COLD_START_ATTR_NAME, mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_COLD_START.getName()));
            serializer.writeRaw(',');
            serializer.writeStringField(FUNCTION_TRACE_ID_ATTR_NAME, mdcPropertyMap.get(PowertoolsLoggedFields.FUNCTION_TRACE_ID.getName()));
            String correlationId = mdcPropertyMap.get(PowertoolsLoggedFields.CORRELATION_ID.getName());
            if (correlationId != null) {
                serializer.writeRaw(',');
                serializer.writeStringField(CORRELATION_ID_ATTR_NAME, correlationId);
            }
        }
    }

    private void serializeCloudInfo(JsonSerializer serializer, String arn) {
        if (this.includeCloudInfo) {
            serializer.writeRaw(',');
            serializer.writeStringField(CLOUD_PROVIDER_ATTR_NAME, CLOUD_PROVIDER);
            serializer.writeRaw(',');
            serializer.writeStringField(CLOUD_SERVICE_ATTR_NAME, CLOUD_SERVICE);
            if (arn != null) {
                String[] arnParts = arn.split(":");
                serializer.writeRaw(',');
                serializer.writeStringField(CLOUD_REGION_ATTR_NAME, arnParts[3]);
                serializer.writeRaw(',');
                serializer.writeStringField(CLOUD_ACCOUNT_ATTR_NAME, arnParts[4]);
            }
        }
    }

    private void serializeException(ILoggingEvent event, JsonSerializer serializer) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            if (this.throwableConverter != null) {
                this.serializeException(serializer, throwableProxy.getClassName(), throwableProxy.getMessage(), this.throwableConverter.convert((Object)event));
            } else if (throwableProxy instanceof ThrowableProxy) {
                Throwable throwable = ((ThrowableProxy)throwableProxy).getThrowable();
                this.serializeException(serializer, throwable.getClass().getName(), throwable.getMessage(), Arrays.toString(throwable.getStackTrace()));
            } else {
                this.serializeException(serializer, throwableProxy.getClassName(), throwableProxy.getMessage(), this.throwableProxyConverter.convert(event));
            }
        }
    }

    public byte[] footerBytes() {
        return new byte[0];
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.throwableConverter = throwableConverter;
    }

    public void setIncludeCloudInfo(boolean includeCloudInfo) {
        this.includeCloudInfo = includeCloudInfo;
    }

    public void setIncludeFaasInfo(boolean includeFaasInfo) {
        this.includeFaasInfo = includeFaasInfo;
    }

    private void serializeException(JsonSerializer serializer, String className, String message, String stackTrace) {
        serializer.writeRaw(',');
        serializer.writeObjectField(EXCEPTION_MSG_ATTR_NAME, (Object)message);
        serializer.writeRaw(',');
        serializer.writeObjectField(EXCEPTION_CLASS_ATTR_NAME, (Object)className);
        serializer.writeRaw(',');
        serializer.writeObjectField(EXCEPTION_STACK_ATTR_NAME, (Object)stackTrace);
    }
}

