/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.utilities.jmespath;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPInputStream;
import software.amazon.lambda.powertools.utilities.jmespath.Base64Function;

public class Base64GZipFunction
extends BaseFunction {
    public Base64GZipFunction() {
        super("powertools_base64_gzip", ArgumentConstraints.typeOf((JmesPathType)JmesPathType.STRING));
    }

    public static String decompress(byte[] compressed) {
        if (compressed == null || compressed.length == 0) {
            return null;
        }
        if (!Base64GZipFunction.isCompressed(compressed)) {
            return new String(compressed, StandardCharsets.UTF_8);
        }
        try {
            String line;
            StringBuilder out = new StringBuilder();
            GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(compressed));
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8));
            while ((line = bf.readLine()) != null) {
                out.append(line);
            }
            return out.toString();
        }
        catch (IOException e) {
            return new String(compressed, StandardCharsets.UTF_8);
        }
    }

    public static boolean isCompressed(byte[] compressed) {
        return compressed[0] == 31 && compressed[1] == -117;
    }

    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        Object value = arguments.get(0).value();
        String encodedString = runtime.toString(value);
        String decompressString = Base64GZipFunction.decompress(Base64Function.decode(encodedString.getBytes(StandardCharsets.UTF_8)));
        if (decompressString == null) {
            return (T)runtime.createNull();
        }
        return (T)runtime.createString(decompressString);
    }
}

