/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.util.SdkUserAgent;

public final class UserAgentUtils {
    private static final Logger log = LoggerFactory.getLogger(UserAgentUtils.class);
    private static final String USER_AGENT_SEP = "/";
    private static final String USER_AGENT_NAME = "aws-msk-iam-auth";
    private static final String VERSION_INFO_FILE = "version.properties";
    private static final String[] AGENT_COMPONENTS = new String[]{"aws-msk-iam-auth", UserAgentUtils.getLibraryVersion(), SdkUserAgent.create().userAgent()};
    private static final String USER_AGENT_STRING = UserAgentUtils.generateUserAgentString(AGENT_COMPONENTS);

    private static final String generateUserAgentString(String[] components) {
        StringJoiner joiner = new StringJoiner(USER_AGENT_SEP);
        for (String component : components) {
            joiner.add(component);
        }
        return joiner.toString();
    }

    private static String getLibraryVersion() {
        String version = "unknown-version";
        try (InputStream inputStream = UserAgentUtils.getVersionInfoFileAsStream();){
            if (inputStream == null) {
                log.info("Unable to load version information for msk iam auth plugin");
            } else {
                Properties versionProperties = new Properties();
                versionProperties.load(inputStream);
                version = versionProperties.getProperty("version");
            }
        }
        catch (Exception e) {
            log.info("Unable to load version information for the running SDK: " + e.getMessage());
        }
        return version;
    }

    public static String getUserAgentValue() {
        return USER_AGENT_STRING;
    }

    private static InputStream getVersionInfoFileAsStream() {
        ClassLoader loader;
        URL url = UserAgentUtils.class.getResource(VERSION_INFO_FILE);
        if (url == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
            url = loader.getResource(VERSION_INFO_FILE);
        }
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

