/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.VersionInfoUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.payloadoffloading.CountingOutputStream;

public class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);

    public static long getStringSizeInBytes(String str) {
        CountingOutputStream counterOutputStream = new CountingOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counterOutputStream, "UTF-8");
            writer.write(str);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            String errorMessage = "Failed to calculate the size of payload.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return counterOutputStream.getTotalSize();
    }

    public static String getUserAgentHeader(String clientName) {
        return clientName + "/" + VersionInfoUtils.getVersion();
    }
}

